"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation_shallow import ActionRelationShallow, ActionRelationShallowPlain
from .credential import Credential, CredentialPlain
from .network_provision_input import NetworkProvisionInput, NetworkProvisionInputPlain


class NetworkRelation(DevopnessBaseModel):
    """
    NetworkRelation

    Attributes:
        id (int): The unique id of the given record
        project_id (int): Numeric ID of the project to which the network belongs to
        environment_id (int): Numeric ID of the environment to which the network belongs to
        created_by (int): The id of the user who created the network
        is_auto_generated (bool): If true, the network is auto-generated
        provider_name (str): The name of the cloud provider
        provider_name_human_readable (str): The human readable version of the provider&#39;s name
        credential (Credential, optional):
        name (str): The networks&#39;s name
        provision_input (NetworkProvisionInput):
        last_action (ActionRelationShallow, optional):
        created_at (str, optional): The date and time when the record was created
        updated_at (str, optional): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique id of the given record")
    project_id: StrictInt = Field(
        description="Numeric ID of the project to which the network belongs to"
    )
    environment_id: StrictInt = Field(
        description="Numeric ID of the environment to which the network belongs to"
    )
    created_by: StrictInt = Field(
        description="The id of the user who created the network"
    )
    is_auto_generated: StrictBool = Field(
        description="If true, the network is auto-generated"
    )
    provider_name: StrictStr = Field(description="The name of the cloud provider")
    provider_name_human_readable: StrictStr = Field(
        description="The human readable version of the provider's name"
    )
    credential: Optional[Credential] = None
    name: StrictStr = Field(description="The networks's name")
    provision_input: NetworkProvisionInput
    last_action: Optional[ActionRelationShallow] = None
    created_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was last updated"
    )


class NetworkRelationPlain(TypedDict, total=False):
    """
    Plain version of NetworkRelation.
    """

    id: Required[int]
    project_id: Required[int]
    environment_id: Required[int]
    created_by: Required[int]
    is_auto_generated: Required[bool]
    provider_name: Required[str]
    provider_name_human_readable: Required[str]
    credential: Optional[
        Union[
            Credential,
            CredentialPlain,
        ]
    ]
    name: Required[str]
    provision_input: Required[
        Union[
            NetworkProvisionInput,
            NetworkProvisionInputPlain,
        ]
    ]
    last_action: Optional[
        Union[
            ActionRelationShallow,
            ActionRelationShallowPlain,
        ]
    ]
    created_at: Optional[str]
    updated_at: Optional[str]
