"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel


class ProjectCreate(DevopnessBaseModel):
    """
    ProjectCreate

    Attributes:
        name (str): The name of the project. Must not be greater than 60 characters.
        organization_id (int, optional): The ID of the organization that owns the project.
        logo_image (str, optional): A base64 string representation of the logo image.
        logo_url (str, optional): A URL path to the project&#39;s logo image. Must be a valid URL.
    """

    name: StrictStr = Field(
        description="The name of the project. Must not be greater than 60 characters."
    )
    organization_id: Optional[StrictInt] = Field(
        default=None, description="The ID of the organization that owns the project."
    )
    logo_image: Optional[StrictStr] = Field(
        default=None, description="A base64 string representation of the logo image."
    )
    logo_url: Optional[StrictStr] = Field(
        default=None,
        description="A URL path to the project's logo image. Must be a valid URL.",
    )


class ProjectCreatePlain(TypedDict, total=False):
    """
    Plain version of ProjectCreate.
    """

    name: Required[str]
    organization_id: Optional[int]
    logo_image: Optional[str]
    logo_url: Optional[str]
