"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .linked_resource_data import LinkedResourceData, LinkedResourceDataPlain
from .resource_link_child import ResourceLinkChild, ResourceLinkChildPlain


class ResourceLinkRelation(DevopnessBaseModel):
    """
    ResourceLinkRelation

    Attributes:
        link_type (str): The link type to related resource (&#x60;child&#x60; or &#x60;parent&#x60;)
        resource_type_human_readable (str): The human readable resource type
        resource_type (str): The linked resource type
        resource_id (int): The linked resource ID
        can_be_unlinked (bool): If false, the link cannot be manually removed
        linked_resource_data (LinkedResourceData):
        children (List[ResourceLinkChild], optional):
    """

    link_type: StrictStr = Field(
        description="The link type to related resource (`child` or `parent`)"
    )
    resource_type_human_readable: StrictStr = Field(
        description="The human readable resource type"
    )
    resource_type: StrictStr = Field(description="The linked resource type")
    resource_id: StrictInt = Field(description="The linked resource ID")
    can_be_unlinked: StrictBool = Field(
        description="If false, the link cannot be manually removed"
    )
    linked_resource_data: LinkedResourceData
    children: Optional[List[ResourceLinkChild]] = None


class ResourceLinkRelationPlain(TypedDict, total=False):
    """
    Plain version of ResourceLinkRelation.
    """

    link_type: Required[str]
    resource_type_human_readable: Required[str]
    resource_type: Required[str]
    resource_id: Required[int]
    can_be_unlinked: Required[bool]
    linked_resource_data: Required[
        Union[
            LinkedResourceData,
            LinkedResourceDataPlain,
        ]
    ]
    children: Optional[
        List[
            Union[
                ResourceLinkChild,
                ResourceLinkChildPlain,
            ]
        ]
    ]
