"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .resource_operation import ResourceOperation, ResourceOperationPlain
from .resource_type import ResourceType, ResourceTypePlain
from .resource_type_related import ResourceTypeRelated, ResourceTypeRelatedPlain


class ResourceTypeRelation(DevopnessBaseModel):
    """
    ResourceTypeRelation

    Attributes:
        resource_type (ResourceType):
        resource_type_human_readable (str): Human readable version of the resource type
        resource_type_human_readable_plural (str): Human readable version of the resource type, in plural form
        supported_operations (List[ResourceOperation]): A list of resource operations
        can_be_child_of (List[ResourceTypeRelated]): A list of related resources
        can_be_parent_of (List[ResourceTypeRelated]): A list of related resources
    """

    resource_type: ResourceType
    resource_type_human_readable: StrictStr = Field(
        description="Human readable version of the resource type"
    )
    resource_type_human_readable_plural: StrictStr = Field(
        description="Human readable version of the resource type, in plural form"
    )
    supported_operations: List[ResourceOperation] = Field(
        description="A list of resource operations"
    )
    can_be_child_of: List[ResourceTypeRelated] = Field(
        description="A list of related resources"
    )
    can_be_parent_of: List[ResourceTypeRelated] = Field(
        description="A list of related resources"
    )


class ResourceTypeRelationPlain(TypedDict, total=False):
    """
    Plain version of ResourceTypeRelation.
    """

    resource_type: Required[
        Union[
            ResourceType,
            ResourceTypePlain,
        ]
    ]
    resource_type_human_readable: Required[str]
    resource_type_human_readable_plural: Required[str]
    supported_operations: Required[
        List[
            Union[
                ResourceOperation,
                ResourceOperationPlain,
            ]
        ]
    ]
    can_be_child_of: Required[
        List[
            Union[
                ResourceTypeRelated,
                ResourceTypeRelatedPlain,
            ]
        ]
    ]
    can_be_parent_of: Required[
        List[
            Union[
                ResourceTypeRelated,
                ResourceTypeRelatedPlain,
            ]
        ]
    ]
