"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .role_relation import RoleRelation, RoleRelationPlain


class Role(DevopnessBaseModel):
    """
    Role

    Attributes:
        id (int): The unique ID of the given role
        name (str): The name of the given role
        description (str): Description of this role
        project_id (int): The ID of the project this role belongs to
        is_predefined (bool): Defines if the role is predefined or custom
        permissions (List[str]): The list of permissions granted for this role
        parent (RoleRelation):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique ID of the given role")
    name: StrictStr = Field(description="The name of the given role")
    description: StrictStr = Field(description="Description of this role")
    project_id: Optional[StrictInt] = Field(
        description="The ID of the project this role belongs to"
    )
    is_predefined: StrictBool = Field(
        description="Defines if the role is predefined or custom"
    )
    permissions: List[StrictStr] = Field(
        description="The list of permissions granted for this role"
    )
    parent: Optional[RoleRelation]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class RolePlain(TypedDict, total=False):
    """
    Plain version of Role.
    """

    id: Required[int]
    name: Required[str]
    description: Required[str]
    project_id: Required[int]
    is_predefined: Required[bool]
    permissions: Required[List[str]]
    parent: Required[
        Union[
            RoleRelation,
            RoleRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
