"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .social_account_displayable_name import (
    SocialAccountDisplayableName,
    SocialAccountDisplayableNamePlain,
)
from .social_account_provider import SocialAccountProvider, SocialAccountProviderPlain


class SocialAccount(DevopnessBaseModel):
    """
    SocialAccount

    Attributes:
        id (int): The ID of the given social account
        user_id (int): The current user&#39;s ID
        provider (SocialAccountProvider):
        provider_human_readable (SocialAccountDisplayableName):
        provider_user_nickname (str): The nickname of the user on the Source Authentication provider
        is_vcs (bool): Tells if the social account provider is a Source Code Provider/Version Control System. e.g. false for Facebook, true for Github
        token_expires_at (str): The date and time indicating when the authentication token will expire at
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The ID of the given social account")
    user_id: StrictInt = Field(description="The current user's ID")
    provider: SocialAccountProvider
    provider_human_readable: SocialAccountDisplayableName
    provider_user_nickname: StrictStr = Field(
        description="The nickname of the user on the Source Authentication provider"
    )
    is_vcs: StrictBool = Field(
        description="Tells if the social account provider is a Source Code Provider/Version Control System. e.g. false for Facebook, true for Github"
    )
    token_expires_at: Optional[StrictStr] = Field(
        description="The date and time indicating when the authentication token will expire at"
    )
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class SocialAccountPlain(TypedDict, total=False):
    """
    Plain version of SocialAccount.
    """

    id: Required[int]
    user_id: Required[int]
    provider: Required[
        Union[
            SocialAccountProvider,
            SocialAccountProviderPlain,
        ]
    ]
    provider_human_readable: Required[
        Union[
            SocialAccountDisplayableName,
            SocialAccountDisplayableNamePlain,
        ]
    ]
    provider_user_nickname: Required[str]
    is_vcs: Required[bool]
    token_expires_at: Required[str]
    created_at: Required[str]
    updated_at: Required[str]
