"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

import json
from enum import Enum
from typing import Literal, Self


class SourceType(str, Enum):
    """
    The 'source type' from which the application source code will be retrieved and deployed. It can be one of `branch`, `tag` or `commit`. If not provided, the application's default branch will be used.
    """

    BRANCH = "branch"
    COMMIT = "commit"
    TAG = "tag"

    def __str__(self) -> str:
        """Return the string representation of the SourceType"""
        return self.value

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SourceType from a JSON string"""
        return cls(json.loads(json_str))


# The plain version of SourceType
SourceTypePlain = Literal[
    "branch",
    "commit",
    "tag",
]
