"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .role_relation import RoleRelation, RoleRelationPlain


class TeamMembershipRelation(DevopnessBaseModel):
    """
    TeamMembershipRelation

    Attributes:
        id (int): The unique ID of the given team
        name (str): The name of the given team
        photo_url (str): The URL to team&#39;s image
        role (RoleRelation):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique ID of the given team")
    name: StrictStr = Field(description="The name of the given team")
    photo_url: StrictStr = Field(description="The URL to team's image")
    role: Optional[RoleRelation]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class TeamMembershipRelationPlain(TypedDict, total=False):
    """
    Plain version of TeamMembershipRelation.
    """

    id: Required[int]
    name: Required[str]
    photo_url: Required[str]
    role: Required[
        Union[
            RoleRelation,
            RoleRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
