"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation_shallow import ActionRelationShallow, ActionRelationShallowPlain
from .application_relation import ApplicationRelation, ApplicationRelationPlain
from .ssl_certificate_relation import (
    SslCertificateRelation,
    SslCertificateRelationPlain,
)
from .user_relation import UserRelation, UserRelationPlain
from .virtual_host_type import VirtualHostType, VirtualHostTypePlain


class VirtualHostRelation(DevopnessBaseModel):
    """
    VirtualHostRelation

    Attributes:
        id (int): Unique ID of the Virtual Host
        type (VirtualHostType):
        type_human_readable (str, optional): The human readable version of the type
        name (str): The name of the Virtual Host
        application (ApplicationRelation):
        root_directory (str): The document root location, within the application directory, that contains the public files to be served when a user visits the domain name associated with this virtual host
        application_listen_address (str): The network name or IP address on which the application linked to this virtual host is configured to listen for incoming requests. A valid address has &#x60;http&#x60; or &#x60;https&#x60; protocol, a domain name or IP address, an optional port and optional path. You can also specify a UNIX-socket using &#x60;unix:&#x60; protocol. Examples: &#x60;http://127.0.0.1:8080&#x60; (for applications exposing port &#x60;8080&#x60;, for example running in a Docker container), &#x60;http://127.0.0.1:3000&#x60; (for applications kept alive by a daemon/background process that listens on port &#x60;3000&#x60;), &#x60;unix:/var/run/example.sock&#x60; (for applications listening on a custom socket)
        ssl_certificate (SslCertificateRelation):
        last_action (ActionRelationShallow, optional):
        created_by_user (UserRelation, optional):
        created_at (str, optional): The date and time when the record was created
        updated_at (str, optional): The date and time when the record was updated
    """

    id: StrictInt = Field(description="Unique ID of the Virtual Host")
    type: VirtualHostType
    type_human_readable: Optional[StrictStr] = Field(
        default=None, description="The human readable version of the type"
    )
    name: StrictStr = Field(description="The name of the Virtual Host")
    application: Optional[ApplicationRelation]
    root_directory: Optional[StrictStr] = Field(
        description="The document root location, within the application directory, that contains the public files to be served when a user visits the domain name associated with this virtual host"
    )
    application_listen_address: Optional[StrictStr] = Field(
        description="The network name or IP address on which the application linked to this virtual host is configured to listen for incoming requests. A valid address has `http` or `https` protocol, a domain name or IP address, an optional port and optional path. You can also specify a UNIX-socket using `unix:` protocol. Examples: `http://127.0.0.1:8080` (for applications exposing port `8080`, for example running in a Docker container), `http://127.0.0.1:3000` (for applications kept alive by a daemon/background process that listens on port `3000`), `unix:/var/run/example.sock` (for applications listening on a custom socket)"
    )
    ssl_certificate: Optional[SslCertificateRelation]
    last_action: Optional[ActionRelationShallow] = None
    created_by_user: Optional[UserRelation] = None
    created_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was updated"
    )


class VirtualHostRelationPlain(TypedDict, total=False):
    """
    Plain version of VirtualHostRelation.
    """

    id: Required[int]
    type: Required[
        Union[
            VirtualHostType,
            VirtualHostTypePlain,
        ]
    ]
    type_human_readable: Optional[str]
    name: Required[str]
    application: Required[
        Union[
            ApplicationRelation,
            ApplicationRelationPlain,
        ]
    ]
    root_directory: Required[str]
    application_listen_address: Required[str]
    ssl_certificate: Required[
        Union[
            SslCertificateRelation,
            SslCertificateRelationPlain,
        ]
    ]
    last_action: Optional[
        Union[
            ActionRelationShallow,
            ActionRelationShallowPlain,
        ]
    ]
    created_by_user: Optional[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    created_at: Optional[str]
    updated_at: Optional[str]
