"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel


class VirtualHostUpdate(DevopnessBaseModel):
    """
    VirtualHostUpdate

    Attributes:
        id (int): The unique ID of the given Virtual Host.
        name (str): The name of the virtual host, unique within the environment. For &#x60;name-based&#x60; type, it must be a valid domain name (e.g., &#x60;my-app.example.com&#x60;). For &#x60;ip-based&#x60; type, it must be a valid IPv4 address or an IPv4 address with port (e.g., &#x60;127.0.0.1:3000&#x60;). Must not be greater than 255 characters.
        root_directory (str, optional): The document root location, within the application directory, that contains the public files to be served when a user visits the domain name associated with this virtual host. Must not be greater than 255 characters.
        application_listen_address (str, optional): The network name or IP address on which the application linked to this virtual host is configured to listen for incoming requests. A valid address has &#x60;http&#x60; or &#x60;https&#x60; protocol, a domain name or IP address, an optional port and optional path. You can also specify a UNIX-socket using &#x60;unix:&#x60; protocol. Examples: &#x60;http://127.0.0.1:8080&#x60; (for applications exposing port &#x60;8080&#x60;, for example running in a Docker container), &#x60;http://127.0.0.1:3000&#x60; (for applications kept alive by a daemon/background process that listens on port &#x60;3000&#x60;), &#x60;unix:/var/run/example.sock&#x60; (for applications listening on a custom socket). Must not be greater than 255 characters.
        application_id (int, optional): The ID of the application to be associated with the virtual host. The value of &#x60;root_directory&#x60; will be relative to this application directory.
    """

    id: StrictInt = Field(description="The unique ID of the given Virtual Host.")
    name: StrictStr = Field(
        description="The name of the virtual host, unique within the environment. For `name-based` type, it must be a valid domain name (e.g., `my-app.example.com`). For `ip-based` type, it must be a valid IPv4 address or an IPv4 address with port (e.g., `127.0.0.1:3000`). Must not be greater than 255 characters."
    )
    root_directory: Optional[StrictStr] = Field(
        default=None,
        description="The document root location, within the application directory, that contains the public files to be served when a user visits the domain name associated with this virtual host. Must not be greater than 255 characters.",
    )
    application_listen_address: Optional[StrictStr] = Field(
        default=None,
        description="The network name or IP address on which the application linked to this virtual host is configured to listen for incoming requests. A valid address has `http` or `https` protocol, a domain name or IP address, an optional port and optional path. You can also specify a UNIX-socket using `unix:` protocol. Examples: `http://127.0.0.1:8080` (for applications exposing port `8080`, for example running in a Docker container), `http://127.0.0.1:3000` (for applications kept alive by a daemon/background process that listens on port `3000`), `unix:/var/run/example.sock` (for applications listening on a custom socket). Must not be greater than 255 characters.",
    )
    application_id: Optional[StrictInt] = Field(
        default=None,
        description="The ID of the application to be associated with the virtual host. The value of `root_directory` will be relative to this application directory.",
    )


class VirtualHostUpdatePlain(TypedDict, total=False):
    """
    Plain version of VirtualHostUpdate.
    """

    id: Required[int]
    name: Required[str]
    root_directory: Optional[str]
    application_listen_address: Optional[str]
    application_id: Optional[int]
