"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Application,
    ApplicationEnvironmentCreate,
    ApplicationEnvironmentCreatePlain,
    ApplicationRelation,
    ApplicationUpdate,
    ApplicationUpdatePlain,
    DeploymentApplicationCreate,
    DeploymentApplicationCreatePlain,
)
from ..utils import parse_query_string


class ApplicationsApiService(DevopnessBaseService):
    """
    ApplicationsApiService - Auto Generated
    """

    def add_application_deployment(
        self,
        application_id: int,
        deployment_application_create: Union[
            DeploymentApplicationCreate,
            DeploymentApplicationCreatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Trigger a new deployment for current application

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/applications/{application_id}/deployments",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, deployment_application_create)

        return DevopnessResponse(response, None)

    def add_environment_application(
        self,
        environment_id: int,
        application_environment_create: Union[
            ApplicationEnvironmentCreate,
            ApplicationEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[Application]:
        """
        Create a new application

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/applications",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, application_environment_create)

        return DevopnessResponse(response, Application)

    def delete_application(
        self,
        application_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given application

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/applications/{application_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def get_application(
        self,
        application_id: int,
    ) -> DevopnessResponse[Application]:
        """
        Get an application by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/applications/{application_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, Application)

    def list_environment_applications(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ApplicationRelation]]:
        """
        Return a list of all Applications belonging to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/applications",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[ApplicationRelation])

    def update_application(
        self,
        application_id: int,
        application_update: Union[
            ApplicationUpdate,
            ApplicationUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing application

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/applications/{application_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._put(endpoint, application_update)

        return DevopnessResponse(response, None)


class ApplicationsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    ApplicationsApiServiceAsync - Auto Generated
    """

    async def add_application_deployment(
        self,
        application_id: int,
        deployment_application_create: Union[
            DeploymentApplicationCreate,
            DeploymentApplicationCreatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Trigger a new deployment for current application

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/applications/{application_id}/deployments",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, deployment_application_create)

        return DevopnessResponse(response, None)

    async def add_environment_application(
        self,
        environment_id: int,
        application_environment_create: Union[
            ApplicationEnvironmentCreate,
            ApplicationEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[Application]:
        """
        Create a new application

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/applications",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, application_environment_create)

        return DevopnessResponse(response, Application)

    async def delete_application(
        self,
        application_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given application

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/applications/{application_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._delete(endpoint)

        return DevopnessResponse(response, None)

    async def get_application(
        self,
        application_id: int,
    ) -> DevopnessResponse[Application]:
        """
        Get an application by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/applications/{application_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, Application)

    async def list_environment_applications(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ApplicationRelation]]:
        """
        Return a list of all Applications belonging to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/applications",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[ApplicationRelation])

    async def update_application(
        self,
        application_id: int,
        application_update: Union[
            ApplicationUpdate,
            ApplicationUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing application

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/applications/{application_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._put(endpoint, application_update)

        return DevopnessResponse(response, None)
