"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import HookTypeParam, HookTypeParamPlain, RequestRelation
from ..utils import parse_query_string


class HooksRequestsApiService(DevopnessBaseService):
    """
    HooksRequestsApiService - Auto Generated
    """

    def list_hook_requests_by_hook_type(
        self,
        hook_id: str,
        hook_type: Union[
            HookTypeParam,
            HookTypeParamPlain,
        ],
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[RequestRelation]]:
        """
        Returns a list of all hook requests belonging to a hook

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/hooks/{hook_type}/{hook_id}/requests",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[RequestRelation])


class HooksRequestsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    HooksRequestsApiServiceAsync - Auto Generated
    """

    async def list_hook_requests_by_hook_type(
        self,
        hook_id: str,
        hook_type: Union[
            HookTypeParam,
            HookTypeParamPlain,
        ],
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[RequestRelation]]:
        """
        Returns a list of all hook requests belonging to a hook

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/hooks/{hook_type}/{hook_id}/requests",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[RequestRelation])
