"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Hook,
    HookPipelineCreate,
    HookPipelineCreatePlain,
    HookRelation,
    HookTypeParam,
    HookTypeParamPlain,
)
from ..utils import parse_query_string


class PipelinesHooksApiService(DevopnessBaseService):
    """
    PipelinesHooksApiService - Auto Generated
    """

    def add_pipeline_hook(
        self,
        hook_type: Union[
            HookTypeParam,
            HookTypeParamPlain,
        ],
        pipeline_id: int,
        hook_pipeline_create: Union[
            HookPipelineCreate,
            HookPipelineCreatePlain,
        ],
    ) -> DevopnessResponse[Hook]:
        """
        Create a hook to a specific pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/hooks/{hook_type}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, hook_pipeline_create)

        return DevopnessResponse(response, Hook)

    def list_pipeline_hooks(
        self,
        pipeline_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[HookRelation]]:
        """
        List all hooks in a pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/hooks",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[HookRelation])


class PipelinesHooksApiServiceAsync(DevopnessBaseServiceAsync):
    """
    PipelinesHooksApiServiceAsync - Auto Generated
    """

    async def add_pipeline_hook(
        self,
        hook_type: Union[
            HookTypeParam,
            HookTypeParamPlain,
        ],
        pipeline_id: int,
        hook_pipeline_create: Union[
            HookPipelineCreate,
            HookPipelineCreatePlain,
        ],
    ) -> DevopnessResponse[Hook]:
        """
        Create a hook to a specific pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/hooks/{hook_type}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, hook_pipeline_create)

        return DevopnessResponse(response, Hook)

    async def list_pipeline_hooks(
        self,
        pipeline_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[HookRelation]]:
        """
        List all hooks in a pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/hooks",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[HookRelation])
