"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Environment,
    EnvironmentProjectCreate,
    EnvironmentProjectCreatePlain,
    EnvironmentRelation,
)
from ..utils import parse_query_string


class ProjectsEnvironmentsApiService(DevopnessBaseService):
    """
    ProjectsEnvironmentsApiService - Auto Generated
    """

    def add_project_environment(
        self,
        project_id: int,
        environment_project_create: Union[
            EnvironmentProjectCreate,
            EnvironmentProjectCreatePlain,
        ],
    ) -> DevopnessResponse[Environment]:
        """
        Create a new environment on the current project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/environments",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, environment_project_create)

        return DevopnessResponse(response, Environment)

    def list_project_environments(
        self,
        project_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[EnvironmentRelation]]:
        """
        Return a list of all environments belonging to a project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/projects/{project_id}/environments",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[EnvironmentRelation])


class ProjectsEnvironmentsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    ProjectsEnvironmentsApiServiceAsync - Auto Generated
    """

    async def add_project_environment(
        self,
        project_id: int,
        environment_project_create: Union[
            EnvironmentProjectCreate,
            EnvironmentProjectCreatePlain,
        ],
    ) -> DevopnessResponse[Environment]:
        """
        Create a new environment on the current project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/environments",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, environment_project_create)

        return DevopnessResponse(response, Environment)

    async def list_project_environments(
        self,
        project_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[EnvironmentRelation]]:
        """
        Return a list of all environments belonging to a project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/projects/{project_id}/environments",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[EnvironmentRelation])
