"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    SslCertificate,
    SslCertificateEnvironmentCreate,
    SslCertificateEnvironmentCreatePlain,
    SslCertificateRelation,
)
from ..utils import parse_query_string


class SSLCertificatesApiService(DevopnessBaseService):
    """
    SSLCertificatesApiService - Auto Generated
    """

    def add_environment_ssl_certificate(
        self,
        environment_id: int,
        ssl_certificate_environment_create: Union[
            SslCertificateEnvironmentCreate,
            SslCertificateEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[SslCertificate]:
        """
        Create a new ssl certificate

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/ssl-certificates",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, ssl_certificate_environment_create)

        return DevopnessResponse(response, SslCertificate)

    def delete_ssl_certificate(
        self,
        ssl_certificate_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given SSL Certificate

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/ssl-certificates/{ssl_certificate_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def get_ssl_certificate(
        self,
        ssl_certificate_id: int,
    ) -> DevopnessResponse[SslCertificate]:
        """
        Get details of a single SSL certificate

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/ssl-certificates/{ssl_certificate_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, SslCertificate)

    def list_environment_ssl_certificates(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[SslCertificateRelation]]:
        """
        Return a list of all SSL Certificates belonging to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/ssl-certificates",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[SslCertificateRelation])


class SSLCertificatesApiServiceAsync(DevopnessBaseServiceAsync):
    """
    SSLCertificatesApiServiceAsync - Auto Generated
    """

    async def add_environment_ssl_certificate(
        self,
        environment_id: int,
        ssl_certificate_environment_create: Union[
            SslCertificateEnvironmentCreate,
            SslCertificateEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[SslCertificate]:
        """
        Create a new ssl certificate

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/ssl-certificates",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, ssl_certificate_environment_create)

        return DevopnessResponse(response, SslCertificate)

    async def delete_ssl_certificate(
        self,
        ssl_certificate_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given SSL Certificate

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/ssl-certificates/{ssl_certificate_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._delete(endpoint)

        return DevopnessResponse(response, None)

    async def get_ssl_certificate(
        self,
        ssl_certificate_id: int,
    ) -> DevopnessResponse[SslCertificate]:
        """
        Get details of a single SSL certificate

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/ssl-certificates/{ssl_certificate_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, SslCertificate)

    async def list_environment_ssl_certificates(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[SslCertificateRelation]]:
        """
        Return a list of all SSL Certificates belonging to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/ssl-certificates",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[SslCertificateRelation])
