"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Variable,
    VariableCreate,
    VariableCreatePlain,
    VariableRelation,
    VariableUpdate,
    VariableUpdatePlain,
)
from ..utils import parse_query_string


class VariablesApiService(DevopnessBaseService):
    """
    VariablesApiService - Auto Generated
    """

    def add_variable(
        self,
        resource_id: int,
        resource_type: str,
        variable_create: Union[
            VariableCreate,
            VariableCreatePlain,
        ],
    ) -> DevopnessResponse[Variable]:
        """
        Create a new variable linked to a resource

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/variables/{resource_type}/{resource_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, variable_create)

        return DevopnessResponse(response, Variable)

    def delete_variable(
        self,
        variable_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a variable by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/variables/{variable_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def get_variable(
        self,
        variable_id: int,
    ) -> DevopnessResponse[Variable]:
        """
        Get a variable by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/variables/{variable_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, Variable)

    def list_variables_by_resource_type(
        self,
        resource_id: int,
        resource_type: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[VariableRelation]]:
        """
        Return a list of variables belonging to a resource

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/variables/{resource_type}/{resource_id}",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[VariableRelation])

    def update_variable(
        self,
        variable_id: int,
        variable_update: Union[
            VariableUpdate,
            VariableUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing variable

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/variables/{variable_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._put(endpoint, variable_update)

        return DevopnessResponse(response, None)


class VariablesApiServiceAsync(DevopnessBaseServiceAsync):
    """
    VariablesApiServiceAsync - Auto Generated
    """

    async def add_variable(
        self,
        resource_id: int,
        resource_type: str,
        variable_create: Union[
            VariableCreate,
            VariableCreatePlain,
        ],
    ) -> DevopnessResponse[Variable]:
        """
        Create a new variable linked to a resource

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/variables/{resource_type}/{resource_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, variable_create)

        return DevopnessResponse(response, Variable)

    async def delete_variable(
        self,
        variable_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a variable by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/variables/{variable_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._delete(endpoint)

        return DevopnessResponse(response, None)

    async def get_variable(
        self,
        variable_id: int,
    ) -> DevopnessResponse[Variable]:
        """
        Get a variable by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/variables/{variable_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, Variable)

    async def list_variables_by_resource_type(
        self,
        resource_id: int,
        resource_type: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[VariableRelation]]:
        """
        Return a list of variables belonging to a resource

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/variables/{resource_type}/{resource_id}",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[VariableRelation])

    async def update_variable(
        self,
        variable_id: int,
        variable_update: Union[
            VariableUpdate,
            VariableUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing variable

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/variables/{variable_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._put(endpoint, variable_update)

        return DevopnessResponse(response, None)
