"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field

from .. import DevopnessBaseModel
from .language_runtime import LanguageRuntime, LanguageRuntimePlain
from .script_runner import ScriptRunner, ScriptRunnerPlain
from .variable_targets import VariableTargets, VariableTargetsPlain


class ApplicationOptions(DevopnessBaseModel):
    """
    ApplicationOptions

    Attributes:
        variable_targets (List[VariableTargets]): The list of VariableTarget
        language_runtimes (List[LanguageRuntime]):
        script_runners (List[ScriptRunner]):
    """

    variable_targets: List[VariableTargets] = Field(
        description="The list of VariableTarget"
    )
    language_runtimes: List[LanguageRuntime]
    script_runners: List[ScriptRunner]


class ApplicationOptionsPlain(TypedDict, total=False):
    """
    Plain version of ApplicationOptions.
    """

    variable_targets: Required[
        List[
            Union[
                VariableTargets,
                VariableTargetsPlain,
            ]
        ]
    ]
    language_runtimes: Required[
        List[
            Union[
                LanguageRuntime,
                LanguageRuntimePlain,
            ]
        ]
    ]
    script_runners: Required[
        List[
            Union[
                ScriptRunner,
                ScriptRunnerPlain,
            ]
        ]
    ]
