"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

import json
from enum import Enum
from typing import Literal, Self


class CloudProviderCode(str, Enum):
    """
    The code of the cloud service provider
    """

    AWS = "aws"
    AZURE = "azure"
    DIGITALOCEAN = "digitalocean"
    GCP = "gcp"

    def __str__(self) -> str:
        """Return the string representation of the CloudProviderCode"""
        return self.value

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CloudProviderCode from a JSON string"""
        return cls(json.loads(json_str))


# The plain version of CloudProviderCode
CloudProviderCodePlain = Literal[
    "aws",
    "azure",
    "digitalocean",
    "gcp",
]
