"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictStr

from .. import DevopnessBaseModel
from .cloud_provider_input_settings_default_value import (
    CloudProviderInputSettingsDefaultValue,
    CloudProviderInputSettingsDefaultValuePlain,
)
from .cloud_provider_property_validation import (
    CloudProviderPropertyValidation,
    CloudProviderPropertyValidationPlain,
)


class CloudProviderInputSettings(DevopnessBaseModel):
    """
    CloudProviderInputSettings

    Attributes:
        name (str): Name of the property
        name_human_readable (str): Human readable version of the property&#39;s name
        default_value (CloudProviderInputSettingsDefaultValue):
        sensitive (bool): Defines if the property data is a sensitive content
        validation (CloudProviderPropertyValidation):
    """

    name: StrictStr = Field(description="Name of the property")
    name_human_readable: StrictStr = Field(
        description="Human readable version of the property's name"
    )
    default_value: Optional[CloudProviderInputSettingsDefaultValue]
    sensitive: StrictBool = Field(
        description="Defines if the property data is a sensitive content"
    )
    validation: CloudProviderPropertyValidation


class CloudProviderInputSettingsPlain(TypedDict, total=False):
    """
    Plain version of CloudProviderInputSettings.
    """

    name: Required[str]
    name_human_readable: Required[str]
    default_value: Required[
        Union[
            CloudProviderInputSettingsDefaultValue,
            CloudProviderInputSettingsDefaultValuePlain,
        ]
    ]
    sensitive: Required[bool]
    validation: Required[
        Union[
            CloudProviderPropertyValidation,
            CloudProviderPropertyValidationPlain,
        ]
    ]
