"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .environment_type import EnvironmentType, EnvironmentTypePlain
from .project_relation import ProjectRelation, ProjectRelationPlain
from .resource_summary_item import ResourceSummaryItem, ResourceSummaryItemPlain


class EnvironmentRelation(DevopnessBaseModel):
    """
    EnvironmentRelation

    Attributes:
        id (int): Unique id of the given record
        type (EnvironmentType):
        type_human_readable (str): The human readable version of the type
        name (str): Environment&#39;s name
        description (str): Environment&#39;s description
        used_credits (int, optional): Number of credits used in the current monthly billing cycle by actions of resources in the environment.
        resource_summary (List[ResourceSummaryItem], optional): Summary of the resource
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
        archived_at (str): The date and time when the record was archived
        project (ProjectRelation):
    """

    id: StrictInt = Field(description="Unique id of the given record")
    type: EnvironmentType
    type_human_readable: StrictStr = Field(
        description="The human readable version of the type"
    )
    name: StrictStr = Field(description="Environment's name")
    description: Optional[StrictStr] = Field(description="Environment's description")
    used_credits: Optional[StrictInt] = Field(
        default=None,
        description="Number of credits used in the current monthly billing cycle by actions of resources in the environment.",
    )
    resource_summary: Optional[List[ResourceSummaryItem]] = Field(
        default=None, description="Summary of the resource"
    )
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )
    archived_at: Optional[StrictStr] = Field(
        description="The date and time when the record was archived"
    )
    project: Optional[ProjectRelation]


class EnvironmentRelationPlain(TypedDict, total=False):
    """
    Plain version of EnvironmentRelation.
    """

    id: Required[int]
    type: Required[
        Union[
            EnvironmentType,
            EnvironmentTypePlain,
        ]
    ]
    type_human_readable: Required[str]
    name: Required[str]
    description: Required[str]
    used_credits: Optional[int]
    resource_summary: Optional[
        List[
            Union[
                ResourceSummaryItem,
                ResourceSummaryItemPlain,
            ]
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
    archived_at: Required[str]
    project: Required[
        Union[
            ProjectRelation,
            ProjectRelationPlain,
        ]
    ]
