"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .environment_type import EnvironmentType, EnvironmentTypePlain


class EnvironmentUpdate(DevopnessBaseModel):
    """
    EnvironmentUpdate

    Attributes:
        id (int): The unique ID of the given Environment.
        type (EnvironmentType):
        name (str): The environment&#39;s name. Must not be greater than 60 characters.
        description (str, optional): The environment&#39;s description. Must not be greater than 255 characters.
    """

    id: StrictInt = Field(description="The unique ID of the given Environment.")
    type: EnvironmentType
    name: StrictStr = Field(
        description="The environment's name. Must not be greater than 60 characters."
    )
    description: Optional[StrictStr] = Field(
        default=None,
        description="The environment's description. Must not be greater than 255 characters.",
    )


class EnvironmentUpdatePlain(TypedDict, total=False):
    """
    Plain version of EnvironmentUpdate.
    """

    id: Required[int]
    type: Required[
        Union[
            EnvironmentType,
            EnvironmentTypePlain,
        ]
    ]
    name: Required[str]
    description: Optional[str]
