"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from datetime import datetime
from typing import (
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel


class HookRequestRelation(DevopnessBaseModel):
    """
    HookRequestRelation

    Attributes:
        id (str): The unique UUID of the hook request
        hook_id (str): The UUID of the hook that the request belongs to
        action_id (int): The id of the action that the request belongs to
        retry_of (str): The UUID of the request that this request is a retry of
        ip_address (str): The IP address of the source that triggered the hook
        url (str, optional): Original URL used on the request
        response_status_code (int, optional): The response status code
        created_at (datetime, optional): The date and time when the record was created
        updated_at (datetime, optional): The date and time when the record was last updated
    """

    id: StrictStr = Field(description="The unique UUID of the hook request")
    hook_id: StrictStr = Field(
        description="The UUID of the hook that the request belongs to"
    )
    action_id: Optional[StrictInt] = Field(
        description="The id of the action that the request belongs to"
    )
    retry_of: Optional[StrictStr] = Field(
        description="The UUID of the request that this request is a retry of"
    )
    ip_address: StrictStr = Field(
        description="The IP address of the source that triggered the hook"
    )
    url: Optional[StrictStr] = Field(
        default=None, description="Original URL used on the request"
    )
    response_status_code: Optional[StrictInt] = Field(
        default=None, description="The response status code"
    )
    created_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was last updated"
    )


class HookRequestRelationPlain(TypedDict, total=False):
    """
    Plain version of HookRequestRelation.
    """

    id: Required[str]
    hook_id: Required[str]
    action_id: Required[int]
    retry_of: Required[str]
    ip_address: Required[str]
    url: Optional[str]
    response_status_code: Optional[int]
    created_at: Optional[datetime]
    updated_at: Optional[datetime]
