"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictStr

from .. import DevopnessBaseModel
from .hook_pipeline_create_settings import (
    HookPipelineCreateSettings,
    HookPipelineCreateSettingsPlain,
)
from .hook_trigger_when import HookTriggerWhen, HookTriggerWhenPlain


class HookUpdate(DevopnessBaseModel):
    """
    HookUpdate

    Attributes:
        id (str): The unique ID of the given Hook. Must be a valid UUID.
        name (str): The name of the outgoing hook. Must not be greater than 60 characters.
        active (bool, optional): Determines if the hook is currently active.
        requires_secret (bool, optional): Tells if requests to this hook must only be accepted when a HTTP header is sent with a message authentication code ([HMAC](https://en.wikipedia.org/wiki/HMAC)) generated based on the secret provided by Devopness and shared by user with external sources.
        secret_algorithm (str, optional): The cryptographic hash function to be used by Devopness when validating digitally signed incoming requests for hooks that require secret validation. This field is required when &lt;code&gt;requires_secret&lt;/code&gt; is &lt;code&gt;true&lt;/code&gt;. Must not be greater than 20 characters.
        secret_header_name (str, optional): The name of the HTTP request header from which the request digital signature should be extracted. This field is required when &lt;code&gt;requires_secret&lt;/code&gt; is &lt;code&gt;true&lt;/code&gt;. Must not be greater than 64 characters.
        trigger_when (HookTriggerWhen, optional):
        settings (HookPipelineCreateSettings, optional):
    """

    id: StrictStr = Field(
        description="The unique ID of the given Hook. Must be a valid UUID."
    )
    name: StrictStr = Field(
        description="The name of the outgoing hook. Must not be greater than 60 characters."
    )
    active: Optional[StrictBool] = Field(
        default=None, description="Determines if the hook is currently active."
    )
    requires_secret: Optional[StrictBool] = Field(
        default=None,
        description="Tells if requests to this hook must only be accepted when a HTTP header is sent with a message authentication code ([HMAC](https://en.wikipedia.org/wiki/HMAC)) generated based on the secret provided by Devopness and shared by user with external sources.",
    )
    secret_algorithm: Optional[StrictStr] = Field(
        default=None,
        description="The cryptographic hash function to be used by Devopness when validating digitally signed incoming requests for hooks that require secret validation. This field is required when <code>requires_secret</code> is <code>true</code>. Must not be greater than 20 characters.",
    )
    secret_header_name: Optional[StrictStr] = Field(
        default=None,
        description="The name of the HTTP request header from which the request digital signature should be extracted. This field is required when <code>requires_secret</code> is <code>true</code>. Must not be greater than 64 characters.",
    )
    trigger_when: Optional[HookTriggerWhen] = None
    settings: Optional[HookPipelineCreateSettings] = None


class HookUpdatePlain(TypedDict, total=False):
    """
    Plain version of HookUpdate.
    """

    id: Required[str]
    name: Required[str]
    active: Optional[bool]
    requires_secret: Optional[bool]
    secret_algorithm: Optional[str]
    secret_header_name: Optional[str]
    trigger_when: Optional[
        Union[
            HookTriggerWhen,
            HookTriggerWhenPlain,
        ]
    ]
    settings: Optional[
        Union[
            HookPipelineCreateSettings,
            HookPipelineCreateSettingsPlain,
        ]
    ]
