"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .team_invitation_status import TeamInvitationStatus, TeamInvitationStatusPlain
from .team_relation import TeamRelation, TeamRelationPlain
from .user_relation import UserRelation, UserRelationPlain


class Invitation(DevopnessBaseModel):
    """
    Invitation

    Attributes:
        id (str): The unique UUID of the given invitation
        email (str): The email of the user that has been invited to team
        status (TeamInvitationStatus):
        status_human_readable (str): Human readable version of the invitation status
        accepted_from_ip (str): The IP of the user who accepted the invitation
        created_by_user (UserRelation):
        user (UserRelation):
        team (TeamRelation):
        accepted_at (str): The date and time when the invitation was accepted
        expires_at (str): The date and time when the invitation will expire
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictStr = Field(description="The unique UUID of the given invitation")
    email: StrictStr = Field(
        description="The email of the user that has been invited to team"
    )
    status: TeamInvitationStatus
    status_human_readable: StrictStr = Field(
        description="Human readable version of the invitation status"
    )
    accepted_from_ip: Optional[StrictStr] = Field(
        description="The IP of the user who accepted the invitation"
    )
    created_by_user: UserRelation
    user: UserRelation
    team: Optional[TeamRelation]
    accepted_at: Optional[StrictStr] = Field(
        description="The date and time when the invitation was accepted"
    )
    expires_at: StrictStr = Field(
        description="The date and time when the invitation will expire"
    )
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class InvitationPlain(TypedDict, total=False):
    """
    Plain version of Invitation.
    """

    id: Required[str]
    email: Required[str]
    status: Required[
        Union[
            TeamInvitationStatus,
            TeamInvitationStatusPlain,
        ]
    ]
    status_human_readable: Required[str]
    accepted_from_ip: Required[str]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    team: Required[
        Union[
            TeamRelation,
            TeamRelationPlain,
        ]
    ]
    accepted_at: Required[str]
    expires_at: Required[str]
    created_at: Required[str]
    updated_at: Required[str]
