"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .language_runtime_engine_versions_inner import (
    LanguageRuntimeEngineVersionsInner,
    LanguageRuntimeEngineVersionsInnerPlain,
)
from .language_runtime_framework import (
    LanguageRuntimeFramework,
    LanguageRuntimeFrameworkPlain,
)


class LanguageRuntime(DevopnessBaseModel):
    """
    LanguageRuntime

    Attributes:
        name (str): The internal name/code of the language runtime
        name_human_readable (str): The formatted name to be displayed in user interfaces
        engine_versions (List[LanguageRuntimeEngineVersionsInner]): The list of the supported versions of the runtime engine
        frameworks (List[LanguageRuntimeFramework]): The list of supported frameworks built on top of the runtime engine
    """

    name: StrictStr = Field(
        description="The internal name/code of the language runtime"
    )
    name_human_readable: StrictStr = Field(
        description="The formatted name to be displayed in user interfaces"
    )
    engine_versions: List[LanguageRuntimeEngineVersionsInner] = Field(
        description="The list of the supported versions of the runtime engine"
    )
    frameworks: List[LanguageRuntimeFramework] = Field(
        description="The list of supported frameworks built on top of the runtime engine"
    )


class LanguageRuntimePlain(TypedDict, total=False):
    """
    Plain version of LanguageRuntime.
    """

    name: Required[str]
    name_human_readable: Required[str]
    engine_versions: Required[
        List[
            Union[
                LanguageRuntimeEngineVersionsInner,
                LanguageRuntimeEngineVersionsInnerPlain,
            ]
        ]
    ]
    frameworks: Required[
        List[
            Union[
                LanguageRuntimeFramework,
                LanguageRuntimeFrameworkPlain,
            ]
        ]
    ]
