"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .team_relation import TeamRelation, TeamRelationPlain
from .user_relation import UserRelation, UserRelationPlain


class Member(DevopnessBaseModel):
    """
    Member

    Attributes:
        user (UserRelation):
        team (TeamRelation):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    user: UserRelation
    team: Optional[TeamRelation]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class MemberPlain(TypedDict, total=False):
    """
    Plain version of Member.
    """

    user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    team: Required[
        Union[
            TeamRelation,
            TeamRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
