"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .static_permission import StaticPermission, StaticPermissionPlain


class PermissionRelation(DevopnessBaseModel):
    """
    PermissionRelation

    Attributes:
        resource_type (str): The type of resource this permission affects
        human_readable (str): Human readable resource name
        permissions (List[StaticPermission]): List of permissions available for this resource
    """

    resource_type: StrictStr = Field(
        description="The type of resource this permission affects"
    )
    human_readable: StrictStr = Field(description="Human readable resource name")
    permissions: List[StaticPermission] = Field(
        description="List of permissions available for this resource"
    )


class PermissionRelationPlain(TypedDict, total=False):
    """
    Plain version of PermissionRelation.
    """

    resource_type: Required[str]
    human_readable: Required[str]
    permissions: Required[
        List[
            Union[
                StaticPermission,
                StaticPermissionPlain,
            ]
        ]
    ]
