"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .pipeline_trigger_when import PipelineTriggerWhen, PipelineTriggerWhenPlain
from .resource_type import ResourceType, ResourceTypePlain
from .step import Step, StepPlain
from .user_relation import UserRelation, UserRelationPlain


class Pipeline(DevopnessBaseModel):
    """
    Pipeline

    Attributes:
        id (int): The unique ID of the given pipeline
        name (str): The pipeline&#39;s name
        environment_id (int): ID of the environment this pipeline belongs to
        project_id (int): ID of the project this pipeline belongs to
        resource_type (ResourceType):
        resource_type_human_readable (str): Human readable version of the resource type
        resource_id (int): The pipeline&#39;s resource ID
        operation (str): The resource operation associated to the pipeline.
        operation_human_readable (str): Human readable version of the operation
        max_parallel_actions (int): Maximum number of actions that can run in parallel for this pipeline. &#x60;0&#x60; means no limit of simultaneous actions. &#x60;1&#x60; means just a single action will be started at a time to run this pipeline.
        trigger_when (PipelineTriggerWhen):
        steps (List[Step]):
        created_by_user (UserRelation):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique ID of the given pipeline")
    name: StrictStr = Field(description="The pipeline's name")
    environment_id: StrictInt = Field(
        description="ID of the environment this pipeline belongs to"
    )
    project_id: StrictInt = Field(
        description="ID of the project this pipeline belongs to"
    )
    resource_type: ResourceType
    resource_type_human_readable: StrictStr = Field(
        description="Human readable version of the resource type"
    )
    resource_id: StrictInt = Field(description="The pipeline's resource ID")
    operation: StrictStr = Field(
        description="The resource operation associated to the pipeline."
    )
    operation_human_readable: StrictStr = Field(
        description="Human readable version of the operation"
    )
    max_parallel_actions: StrictInt = Field(
        description="Maximum number of actions that can run in parallel for this pipeline. `0` means no limit of simultaneous actions. `1` means just a single action will be started at a time to run this pipeline."
    )
    trigger_when: Optional[PipelineTriggerWhen]
    steps: List[Step]
    created_by_user: UserRelation
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class PipelinePlain(TypedDict, total=False):
    """
    Plain version of Pipeline.
    """

    id: Required[int]
    name: Required[str]
    environment_id: Required[int]
    project_id: Required[int]
    resource_type: Required[
        Union[
            ResourceType,
            ResourceTypePlain,
        ]
    ]
    resource_type_human_readable: Required[str]
    resource_id: Required[int]
    operation: Required[str]
    operation_human_readable: Required[str]
    max_parallel_actions: Required[int]
    trigger_when: Required[
        Union[
            PipelineTriggerWhen,
            PipelineTriggerWhenPlain,
        ]
    ]
    steps: Required[
        List[
            Union[
                Step,
                StepPlain,
            ]
        ]
    ]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
