"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .pipeline_trigger_when import PipelineTriggerWhen, PipelineTriggerWhenPlain


class PipelineCreate(DevopnessBaseModel):
    """
    PipelineCreate

    Attributes:
        name (str): The pipeline&#39;s name. Must be at least 3 characters. Must not be greater than 80 characters.
        operation (str): The resource operation associated to the pipeline. Must not be greater than 20 characters.
        max_parallel_actions (int, optional): Maximum number of actions that can run in parallel for this pipeline. &#x60;0&#x60; means no limit of simultaneous actions. &#x60;1&#x60; means just a single action will be started at a time to run this pipeline. Must be between 0 and 10.
        trigger_when (PipelineTriggerWhen, optional):
    """

    name: StrictStr = Field(
        description="The pipeline's name. Must be at least 3 characters. Must not be greater than 80 characters."
    )
    operation: StrictStr = Field(
        description="The resource operation associated to the pipeline. Must not be greater than 20 characters."
    )
    max_parallel_actions: Optional[StrictInt] = Field(
        default=None,
        description="Maximum number of actions that can run in parallel for this pipeline. `0` means no limit of simultaneous actions. `1` means just a single action will be started at a time to run this pipeline. Must be between 0 and 10.",
    )
    trigger_when: Optional[PipelineTriggerWhen] = None


class PipelineCreatePlain(TypedDict, total=False):
    """
    Plain version of PipelineCreate.
    """

    name: Required[str]
    operation: Required[str]
    max_parallel_actions: Optional[int]
    trigger_when: Optional[
        Union[
            PipelineTriggerWhen,
            PipelineTriggerWhenPlain,
        ]
    ]
