"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt

from .. import DevopnessBaseModel
from .pipeline_settings_stage import PipelineSettingsStage, PipelineSettingsStagePlain
from .pipeline_settings_variable import (
    PipelineSettingsVariable,
    PipelineSettingsVariablePlain,
)


class PipelineSettings(DevopnessBaseModel):
    """
    PipelineSettings

    Attributes:
        max_pipelines_per_resource (int, optional):
        is_user_managed (bool, optional): Indicates whether the user has permission to manage the pipeline for the resource operation
        stages (List[PipelineSettingsStage], optional): The list of pipeline setting stage
        variables (List[PipelineSettingsVariable], optional): The list of pipeline setting variable
    """

    max_pipelines_per_resource: Optional[StrictInt] = None
    is_user_managed: Optional[StrictBool] = Field(
        default=None,
        description="Indicates whether the user has permission to manage the pipeline for the resource operation",
    )
    stages: Optional[List[PipelineSettingsStage]] = Field(
        default=None, description="The list of pipeline setting stage"
    )
    variables: Optional[List[PipelineSettingsVariable]] = Field(
        default=None, description="The list of pipeline setting variable"
    )


class PipelineSettingsPlain(TypedDict, total=False):
    """
    Plain version of PipelineSettings.
    """

    max_pipelines_per_resource: Optional[int]
    is_user_managed: Optional[bool]
    stages: Optional[
        List[
            Union[
                PipelineSettingsStage,
                PipelineSettingsStagePlain,
            ]
        ]
    ]
    variables: Optional[
        List[
            Union[
                PipelineSettingsVariable,
                PipelineSettingsVariablePlain,
            ]
        ]
    ]
