"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .os_users_inner import OsUsersInner, OsUsersInnerPlain
from .resource_summary_item import ResourceSummaryItem, ResourceSummaryItemPlain
from .user_relation import UserRelation, UserRelationPlain


class Project(DevopnessBaseModel):
    """
    Project

    Attributes:
        id (int): The Id of the project
        user_id (int): The id of the user that own the project
        name (str): The project&#39;s name
        logo_url (str): A URL path to the project&#39;s logo image
        resource_summary (List[ResourceSummaryItem], optional): Summary of the resource
        os_users (List[OsUsersInner]): The list of the operating system users found in all the servers linked to a project
        created_by_user (UserRelation):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The Id of the project")
    user_id: StrictInt = Field(description="The id of the user that own the project")
    name: StrictStr = Field(description="The project's name")
    logo_url: Optional[StrictStr] = Field(
        description="A URL path to the project's logo image"
    )
    resource_summary: Optional[List[ResourceSummaryItem]] = Field(
        default=None, description="Summary of the resource"
    )
    os_users: List[OsUsersInner] = Field(
        description="The list of the operating system users found in all the servers linked to a project"
    )
    created_by_user: UserRelation
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class ProjectPlain(TypedDict, total=False):
    """
    Plain version of Project.
    """

    id: Required[int]
    user_id: Required[int]
    name: Required[str]
    logo_url: Required[str]
    resource_summary: Optional[
        List[
            Union[
                ResourceSummaryItem,
                ResourceSummaryItemPlain,
            ]
        ]
    ]
    os_users: Required[
        List[
            Union[
                OsUsersInner,
                OsUsersInnerPlain,
            ]
        ]
    ]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
