"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictStr

from .. import DevopnessBaseModel
from .provider_input_settings_validation import (
    ProviderInputSettingsValidation,
    ProviderInputSettingsValidationPlain,
)


class ProviderInputSettings(DevopnessBaseModel):
    """
    ProviderInputSettings

    Attributes:
        name (str): The name of a credential input field
        name_human_readable (str): The human readable version of the input field name
        validation (ProviderInputSettingsValidation):
        default_value (str): The default value of the input field
        sensitive (bool): Defines if the input field data is a sensitive content
    """

    name: StrictStr = Field(description="The name of a credential input field")
    name_human_readable: StrictStr = Field(
        description="The human readable version of the input field name"
    )
    validation: ProviderInputSettingsValidation
    default_value: Optional[StrictStr] = Field(
        description="The default value of the input field"
    )
    sensitive: StrictBool = Field(
        description="Defines if the input field data is a sensitive content"
    )


class ProviderInputSettingsPlain(TypedDict, total=False):
    """
    Plain version of ProviderInputSettings.
    """

    name: Required[str]
    name_human_readable: Required[str]
    validation: Required[
        Union[
            ProviderInputSettingsValidation,
            ProviderInputSettingsValidationPlain,
        ]
    ]
    default_value: Required[str]
    sensitive: Required[bool]
