"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictStr

from .. import DevopnessBaseModel
from .provider_code import ProviderCode, ProviderCodePlain
from .provider_type import ProviderType, ProviderTypePlain


class ProviderRelation(DevopnessBaseModel):
    """
    ProviderRelation

    Attributes:
        active (bool): Tells if the provider is active or not
        code (ProviderCode):
        code_human_readable (str): Human readable version of provider code
        type (ProviderType):
        type_human_readable (str, optional): Human readable version of provider type
    """

    active: StrictBool = Field(description="Tells if the provider is active or not")
    code: ProviderCode
    code_human_readable: StrictStr = Field(
        description="Human readable version of provider code"
    )
    type: ProviderType
    type_human_readable: Optional[StrictStr] = Field(
        default=None, description="Human readable version of provider type"
    )


class ProviderRelationPlain(TypedDict, total=False):
    """
    Plain version of ProviderRelation.
    """

    active: Required[bool]
    code: Required[
        Union[
            ProviderCode,
            ProviderCodePlain,
        ]
    ]
    code_human_readable: Required[str]
    type: Required[
        Union[
            ProviderType,
            ProviderTypePlain,
        ]
    ]
    type_human_readable: Optional[str]
