"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_status import ActionStatus, ActionStatusPlain
from .action_type import ActionType, ActionTypePlain
from .resource_type import ResourceType, ResourceTypePlain


class RelatedAction(DevopnessBaseModel):
    """
    RelatedAction

    Attributes:
        id (int): The Id of the given action
        status (ActionStatus):
        status_human_readable (str, optional): Human readable version of the action status
        type (ActionType):
        type_human_readable (str): Human readable version of the action type
        resource_name (str, optional): The name of the resource
        resource_type (ResourceType):
        resource_type_human_readable (str): Human readable version of the resource type
        url_web_permalink (str): The permalink URL to the action details on Devopness web app
    """

    id: StrictInt = Field(description="The Id of the given action")
    status: ActionStatus
    status_human_readable: Optional[StrictStr] = Field(
        default=None, description="Human readable version of the action status"
    )
    type: ActionType
    type_human_readable: StrictStr = Field(
        description="Human readable version of the action type"
    )
    resource_name: Optional[StrictStr] = Field(
        default=None, description="The name of the resource"
    )
    resource_type: ResourceType
    resource_type_human_readable: StrictStr = Field(
        description="Human readable version of the resource type"
    )
    url_web_permalink: StrictStr = Field(
        description="The permalink URL to the action details on Devopness web app"
    )


class RelatedActionPlain(TypedDict, total=False):
    """
    Plain version of RelatedAction.
    """

    id: Required[int]
    status: Required[
        Union[
            ActionStatus,
            ActionStatusPlain,
        ]
    ]
    status_human_readable: Optional[str]
    type: Required[
        Union[
            ActionType,
            ActionTypePlain,
        ]
    ]
    type_human_readable: Required[str]
    resource_name: Optional[str]
    resource_type: Required[
        Union[
            ResourceType,
            ResourceTypePlain,
        ]
    ]
    resource_type_human_readable: Required[str]
    url_web_permalink: Required[str]
