"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel


class RequestRelation(DevopnessBaseModel):
    """
    RequestRelation

    Attributes:
        id (str): The unique UUID of the hook request
        hook_id (str): The UUID of the hook that the request belongs to
        action_id (int): The ID of the action that the request belongs to
        retry_of (str): The UUID of the request that this request is a retry of
        ip_address (str): The IP address of the source that triggered the hook
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictStr = Field(description="The unique UUID of the hook request")
    hook_id: StrictStr = Field(
        description="The UUID of the hook that the request belongs to"
    )
    action_id: Optional[StrictInt] = Field(
        description="The ID of the action that the request belongs to"
    )
    retry_of: Optional[StrictStr] = Field(
        description="The UUID of the request that this request is a retry of"
    )
    ip_address: StrictStr = Field(
        description="The IP address of the source that triggered the hook"
    )
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class RequestRelationPlain(TypedDict, total=False):
    """
    Plain version of RequestRelation.
    """

    id: Required[str]
    hook_id: Required[str]
    action_id: Required[int]
    retry_of: Required[str]
    ip_address: Required[str]
    created_at: Required[str]
    updated_at: Required[str]
