"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation import ActionRelation, ActionRelationPlain
from .cloud_os_version_code import CloudOsVersionCode, CloudOsVersionCodePlain
from .credential_relation import CredentialRelation, CredentialRelationPlain
from .environment_relation import EnvironmentRelation, EnvironmentRelationPlain
from .operating_system_version import (
    OperatingSystemVersion,
    OperatingSystemVersionPlain,
)
from .project_relation import ProjectRelation, ProjectRelationPlain
from .server_blueprint import ServerBlueprint, ServerBlueprintPlain
from .server_cloud_service_code import (
    ServerCloudServiceCode,
    ServerCloudServiceCodePlain,
)
from .server_provision_input import ServerProvisionInput, ServerProvisionInputPlain
from .server_status import ServerStatus, ServerStatusPlain
from .user_relation import UserRelation, UserRelationPlain


class Server(DevopnessBaseModel):
    """
    Server

    Attributes:
        id (int): The unique id of the given record
        created_by (int): The id of the user who created the server and to whom the server belongs
        name (str): The server&#39;s name
        hostname (str): The server&#39;s hostname
        provider_name (str): The name of the server&#39;s provider.
        provider_name_human_readable (str): The human readable version of the provider&#39;s name
        cloud_service_code (ServerCloudServiceCode):
        ip_address (str, optional): Public ipv4 address for server access
        ssh_port (int): The network port to which the SSH daemon is listening to SSH connections on the server
        os (OperatingSystemVersion):
        os_version_code (CloudOsVersionCode):
        active (bool): Tells if the server is active or not
        status (ServerStatus):
        max_parallel_actions (int): Maximum number of actions that can run in parallel on this server. &#x60;0&#x60; means no limit of simultaneous actions. &#x60;1&#x60; means just a single action will be started at a time to run on this server,
        blueprint (ServerBlueprint):
        provision_input (ServerProvisionInput):
        created_by_user (UserRelation):
        project (ProjectRelation):
        last_action (ActionRelation):
        environment (EnvironmentRelation):
        credential (CredentialRelation):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique id of the given record")
    created_by: StrictInt = Field(
        description="The id of the user who created the server and to whom the server belongs"
    )
    name: StrictStr = Field(description="The server's name")
    hostname: StrictStr = Field(description="The server's hostname")
    provider_name: StrictStr = Field(description="The name of the server's provider.")
    provider_name_human_readable: StrictStr = Field(
        description="The human readable version of the provider's name"
    )
    cloud_service_code: ServerCloudServiceCode
    ip_address: Optional[StrictStr] = Field(
        default=None, description="Public ipv4 address for server access"
    )
    ssh_port: StrictInt = Field(
        description="The network port to which the SSH daemon is listening to SSH connections on the server"
    )
    os: OperatingSystemVersion
    os_version_code: Optional[CloudOsVersionCode]
    active: StrictBool = Field(description="Tells if the server is active or not")
    status: ServerStatus
    max_parallel_actions: StrictInt = Field(
        description="Maximum number of actions that can run in parallel on this server. `0` means no limit of simultaneous actions. `1` means just a single action will be started at a time to run on this server,"
    )
    blueprint: ServerBlueprint
    provision_input: ServerProvisionInput
    created_by_user: UserRelation
    project: Optional[ProjectRelation]
    last_action: Optional[ActionRelation]
    environment: Optional[EnvironmentRelation]
    credential: Optional[CredentialRelation]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class ServerPlain(TypedDict, total=False):
    """
    Plain version of Server.
    """

    id: Required[int]
    created_by: Required[int]
    name: Required[str]
    hostname: Required[str]
    provider_name: Required[str]
    provider_name_human_readable: Required[str]
    cloud_service_code: Required[
        Union[
            ServerCloudServiceCode,
            ServerCloudServiceCodePlain,
        ]
    ]
    ip_address: Optional[str]
    ssh_port: Required[int]
    os: Required[
        Union[
            OperatingSystemVersion,
            OperatingSystemVersionPlain,
        ]
    ]
    os_version_code: Required[
        Union[
            CloudOsVersionCode,
            CloudOsVersionCodePlain,
        ]
    ]
    active: Required[bool]
    status: Required[
        Union[
            ServerStatus,
            ServerStatusPlain,
        ]
    ]
    max_parallel_actions: Required[int]
    blueprint: Required[
        Union[
            ServerBlueprint,
            ServerBlueprintPlain,
        ]
    ]
    provision_input: Required[
        Union[
            ServerProvisionInput,
            ServerProvisionInputPlain,
        ]
    ]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    project: Required[
        Union[
            ProjectRelation,
            ProjectRelationPlain,
        ]
    ]
    last_action: Required[
        Union[
            ActionRelation,
            ActionRelationPlain,
        ]
    ]
    environment: Required[
        Union[
            EnvironmentRelation,
            EnvironmentRelationPlain,
        ]
    ]
    credential: Required[
        Union[
            CredentialRelation,
            CredentialRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
