"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt

from .. import DevopnessBaseModel
from .server_cloud_service_code import (
    ServerCloudServiceCode,
    ServerCloudServiceCodePlain,
)
from .server_provision_input_settings import (
    ServerProvisionInputSettings,
    ServerProvisionInputSettingsPlain,
)


class ServerProvisionInput(DevopnessBaseModel):
    """
    ServerProvisionInput

    Attributes:
        subnet_id (int, optional): The ID of the subnet where to create the server. If not defined, create the server on the default subnet of the cloud provider
        cloud_service_code (ServerCloudServiceCode):
        settings (ServerProvisionInputSettings, optional):
    """

    subnet_id: Optional[StrictInt] = Field(
        default=None,
        description="The ID of the subnet where to create the server. If not defined, create the server on the default subnet of the cloud provider",
    )
    cloud_service_code: ServerCloudServiceCode
    settings: Optional[ServerProvisionInputSettings] = None


class ServerProvisionInputPlain(TypedDict, total=False):
    """
    Plain version of ServerProvisionInput.
    """

    subnet_id: Optional[int]
    cloud_service_code: Required[
        Union[
            ServerCloudServiceCode,
            ServerCloudServiceCodePlain,
        ]
    ]
    settings: Optional[
        Union[
            ServerProvisionInputSettings,
            ServerProvisionInputSettingsPlain,
        ]
    ]
