"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

import json
from enum import Enum
from typing import Literal, Self


class ServiceType(str, Enum):
    """
    Types of OS Services supported by Devopness
    """

    DOCKER = "docker"
    MYSQL = "mysql"
    NEWRELIC_MINUS_INFRA = "newrelic-infra"
    NGINX = "nginx"
    PHP = "php"
    POSTGRESQL = "postgresql"
    REDIS = "redis"
    SUPERVISOR = "supervisor"
    UFW = "ufw"

    def __str__(self) -> str:
        """Return the string representation of the ServiceType"""
        return self.value

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ServiceType from a JSON string"""
        return cls(json.loads(json_str))


# The plain version of ServiceType
ServiceTypePlain = Literal[
    "docker",
    "mysql",
    "newrelic-infra",
    "nginx",
    "php",
    "postgresql",
    "redis",
    "supervisor",
    "ufw",
]
