"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .resource_to_be_linked import ResourceToBeLinked, ResourceToBeLinkedPlain


class SshKeyEnvironmentCreate(DevopnessBaseModel):
    """
    SshKeyEnvironmentCreate

    Attributes:
        linked_resources (List[ResourceToBeLinked], optional): The resources to be linked with this resource
        name (str): The ssh key&#39;s name. Must not be greater than 60 characters.
        public_key (str): The public key of the ssh key.
    """

    linked_resources: Optional[List[ResourceToBeLinked]] = Field(
        default=None, description="The resources to be linked with this resource"
    )
    name: StrictStr = Field(
        description="The ssh key's name. Must not be greater than 60 characters."
    )
    public_key: StrictStr = Field(description="The public key of the ssh key.")


class SshKeyEnvironmentCreatePlain(TypedDict, total=False):
    """
    Plain version of SshKeyEnvironmentCreate.
    """

    linked_resources: Optional[
        List[
            Union[
                ResourceToBeLinked,
                ResourceToBeLinkedPlain,
            ]
        ]
    ]
    name: Required[str]
    public_key: Required[str]
