"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .subnet_provision_input import SubnetProvisionInput, SubnetProvisionInputPlain
from .subnet_type import SubnetType, SubnetTypePlain


class SubnetNetworkCreate(DevopnessBaseModel):
    """
    SubnetNetworkCreate

    Attributes:
        name (str): The subnet&#39;s name. Must be between 1 and 63 characters.
        type (SubnetType):
        provision_input (SubnetProvisionInput):
        credential_id (int): The ID of the cloud credential.
    """

    name: StrictStr = Field(
        description="The subnet's name. Must be between 1 and 63 characters."
    )
    type: SubnetType
    provision_input: SubnetProvisionInput
    credential_id: StrictInt = Field(description="The ID of the cloud credential.")


class SubnetNetworkCreatePlain(TypedDict, total=False):
    """
    Plain version of SubnetNetworkCreate.
    """

    name: Required[str]
    type: Required[
        Union[
            SubnetType,
            SubnetTypePlain,
        ]
    ]
    provision_input: Required[
        Union[
            SubnetProvisionInput,
            SubnetProvisionInputPlain,
        ]
    ]
    credential_id: Required[int]
