"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .language import Language, LanguagePlain
from .social_account_relation import SocialAccountRelation, SocialAccountRelationPlain


class User(DevopnessBaseModel):
    """
    User

    Attributes:
        id (int): The unique ID of the given user
        name (str): User&#39;s full name
        email (str): The e-mail that will uniquely identify the user on the system and become its login credential
        url_slug (str, optional): The URL Slug of the user
        language (Language):
        active (bool): Tells if the user is active or not
        social_accounts (List[SocialAccountRelation]):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique ID of the given user")
    name: StrictStr = Field(description="User's full name")
    email: StrictStr = Field(
        description="The e-mail that will uniquely identify the user on the system and become its login credential"
    )
    url_slug: Optional[StrictStr] = Field(
        default=None, description="The URL Slug of the user"
    )
    language: Optional[Language]
    active: StrictBool = Field(description="Tells if the user is active or not")
    social_accounts: List[Optional[SocialAccountRelation]]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class UserPlain(TypedDict, total=False):
    """
    Plain version of User.
    """

    id: Required[int]
    name: Required[str]
    email: Required[str]
    url_slug: Optional[str]
    language: Required[
        Union[
            Language,
            LanguagePlain,
        ]
    ]
    active: Required[bool]
    social_accounts: Required[
        List[
            Union[
                SocialAccountRelation,
                SocialAccountRelationPlain,
            ]
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
