"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .language import Language, LanguagePlain


class UserUpdate(DevopnessBaseModel):
    """
    UserUpdate

    Attributes:
        id (str): The unique ID of the given User.
        name (str): User&#39;s full name. Must be at least 5 characters. Must not be greater than 60 characters.
        email (str): The e-mail that will uniquely identify the user on the system and become its login credential. Must be a valid email address.
        url_slug (str): The URL Slug of the user. Must not be greater than 255 characters.
        language (Language, optional):
    """

    id: StrictStr = Field(description="The unique ID of the given User.")
    name: StrictStr = Field(
        description="User's full name. Must be at least 5 characters. Must not be greater than 60 characters."
    )
    email: StrictStr = Field(
        description="The e-mail that will uniquely identify the user on the system and become its login credential. Must be a valid email address."
    )
    url_slug: StrictStr = Field(
        description="The URL Slug of the user. Must not be greater than 255 characters."
    )
    language: Optional[Language] = None


class UserUpdatePlain(TypedDict, total=False):
    """
    Plain version of UserUpdate.
    """

    id: Required[str]
    name: Required[str]
    email: Required[str]
    url_slug: Required[str]
    language: Optional[
        Union[
            Language,
            LanguagePlain,
        ]
    ]
