"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel


class UserVerify(DevopnessBaseModel):
    """
    UserVerify

    Attributes:
        email (str): The email of the user&#39;s account. Must be a valid email address. Must not be greater than 255 characters.
        token (str): The security token of the account. Must not be greater than 255 characters.
        name (str): The new user name to account. Must be at least 3 characters. Must not be greater than 255 characters.
        url_slug (str, optional): The URL Slug of the account. Must not be greater than 255 characters.
        password (str): The new password to account. Must be at least 8 characters.
    """

    email: StrictStr = Field(
        description="The email of the user's account. Must be a valid email address. Must not be greater than 255 characters."
    )
    token: StrictStr = Field(
        description="The security token of the account. Must not be greater than 255 characters."
    )
    name: StrictStr = Field(
        description="The new user name to account. Must be at least 3 characters. Must not be greater than 255 characters."
    )
    url_slug: Optional[StrictStr] = Field(
        default=None,
        description="The URL Slug of the account. Must not be greater than 255 characters.",
    )
    password: StrictStr = Field(
        description="The new password to account. Must be at least 8 characters."
    )


class UserVerifyPlain(TypedDict, total=False):
    """
    Plain version of UserVerify.
    """

    email: Required[str]
    token: Required[str]
    name: Required[str]
    url_slug: Optional[str]
    password: Required[str]
