# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoOmpFeatureTemplateArgs', 'CiscoOmpFeatureTemplate']

@pulumi.input_type
class CiscoOmpFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 advertise_ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs']]]] = None,
                 advertise_ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs']]]] = None,
                 advertisement_interval: Optional[pulumi.Input[int]] = None,
                 advertisement_interval_variable: Optional[pulumi.Input[str]] = None,
                 ecmp_limit: Optional[pulumi.Input[int]] = None,
                 ecmp_limit_variable: Optional[pulumi.Input[str]] = None,
                 eor_timer: Optional[pulumi.Input[int]] = None,
                 eor_timer_variable: Optional[pulumi.Input[str]] = None,
                 graceful_restart: Optional[pulumi.Input[bool]] = None,
                 graceful_restart_timer: Optional[pulumi.Input[int]] = None,
                 graceful_restart_timer_variable: Optional[pulumi.Input[str]] = None,
                 graceful_restart_variable: Optional[pulumi.Input[str]] = None,
                 holdtime: Optional[pulumi.Input[int]] = None,
                 holdtime_variable: Optional[pulumi.Input[str]] = None,
                 ignore_region_path_length: Optional[pulumi.Input[bool]] = None,
                 ignore_region_path_length_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 overlay_as: Optional[pulumi.Input[int]] = None,
                 overlay_as_variable: Optional[pulumi.Input[str]] = None,
                 send_path_limit: Optional[pulumi.Input[int]] = None,
                 send_path_limit_variable: Optional[pulumi.Input[str]] = None,
                 shutdown: Optional[pulumi.Input[bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[str]] = None,
                 transport_gateway: Optional[pulumi.Input[str]] = None,
                 transport_gateway_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CiscoOmpFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs']]] advertise_ipv4_routes: Advertise locally learned routes to OMP
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs']]] advertise_ipv6_routes: Advertise locally learned routes to OMP
        :param pulumi.Input[int] advertisement_interval: Set the time between OMP Update packets - Range: `0`-`65535` - Default value: `1`
        :param pulumi.Input[str] advertisement_interval_variable: Variable name
        :param pulumi.Input[int] ecmp_limit: Set maximum number of OMP paths to install in vEdge route table - Range: `1`-`16` - Default value: `4`
        :param pulumi.Input[str] ecmp_limit_variable: Variable name
        :param pulumi.Input[int] eor_timer: End of RIB timer <1..604800> seconds - Range: `1`-`3600` - Default value: `300`
        :param pulumi.Input[str] eor_timer_variable: Variable name
        :param pulumi.Input[bool] graceful_restart: Enable or disable OMP graceful restart - Default value: `true`
        :param pulumi.Input[int] graceful_restart_timer: Set the OMP graceful restart timer - Range: `1`-`604800` - Default value: `43200`
        :param pulumi.Input[str] graceful_restart_timer_variable: Variable name
        :param pulumi.Input[str] graceful_restart_variable: Variable name
        :param pulumi.Input[int] holdtime: Set how long to wait before closing OMP peer connection - Default value: `60`
        :param pulumi.Input[str] holdtime_variable: Variable name
        :param pulumi.Input[bool] ignore_region_path_length: Ignore Region-Path Length During Best-Path Algorithm - Default value: `false`
        :param pulumi.Input[str] ignore_region_path_length_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] omp_admin_distance_ipv4: omp-admin-distance-ipv4 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[int] omp_admin_distance_ipv6: omp-admin-distance-ipv6 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[int] overlay_as: Set Overlay AS number <1..4294967295> or <XX.YY> - Range: `1`-`4294967295`
        :param pulumi.Input[str] overlay_as_variable: Variable name
        :param pulumi.Input[int] send_path_limit: Set number of TLOC routes advertised between vSmart and vEdge - Range: `1`-`16` - Default value: `4`
        :param pulumi.Input[str] send_path_limit_variable: Variable name
        :param pulumi.Input[bool] shutdown: Enable or disable OMP - Default value: `false`
        :param pulumi.Input[str] shutdown_variable: Variable name
        :param pulumi.Input[str] transport_gateway: Transport gateway path computation - Choices: `prefer`, `ecmp-with-direct-path`
        :param pulumi.Input[str] transport_gateway_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if advertise_ipv4_routes is not None:
            pulumi.set(__self__, "advertise_ipv4_routes", advertise_ipv4_routes)
        if advertise_ipv6_routes is not None:
            pulumi.set(__self__, "advertise_ipv6_routes", advertise_ipv6_routes)
        if advertisement_interval is not None:
            pulumi.set(__self__, "advertisement_interval", advertisement_interval)
        if advertisement_interval_variable is not None:
            pulumi.set(__self__, "advertisement_interval_variable", advertisement_interval_variable)
        if ecmp_limit is not None:
            pulumi.set(__self__, "ecmp_limit", ecmp_limit)
        if ecmp_limit_variable is not None:
            pulumi.set(__self__, "ecmp_limit_variable", ecmp_limit_variable)
        if eor_timer is not None:
            pulumi.set(__self__, "eor_timer", eor_timer)
        if eor_timer_variable is not None:
            pulumi.set(__self__, "eor_timer_variable", eor_timer_variable)
        if graceful_restart is not None:
            pulumi.set(__self__, "graceful_restart", graceful_restart)
        if graceful_restart_timer is not None:
            pulumi.set(__self__, "graceful_restart_timer", graceful_restart_timer)
        if graceful_restart_timer_variable is not None:
            pulumi.set(__self__, "graceful_restart_timer_variable", graceful_restart_timer_variable)
        if graceful_restart_variable is not None:
            pulumi.set(__self__, "graceful_restart_variable", graceful_restart_variable)
        if holdtime is not None:
            pulumi.set(__self__, "holdtime", holdtime)
        if holdtime_variable is not None:
            pulumi.set(__self__, "holdtime_variable", holdtime_variable)
        if ignore_region_path_length is not None:
            pulumi.set(__self__, "ignore_region_path_length", ignore_region_path_length)
        if ignore_region_path_length_variable is not None:
            pulumi.set(__self__, "ignore_region_path_length_variable", ignore_region_path_length_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if omp_admin_distance_ipv4 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4", omp_admin_distance_ipv4)
        if omp_admin_distance_ipv4_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4_variable", omp_admin_distance_ipv4_variable)
        if omp_admin_distance_ipv6 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6", omp_admin_distance_ipv6)
        if omp_admin_distance_ipv6_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6_variable", omp_admin_distance_ipv6_variable)
        if overlay_as is not None:
            pulumi.set(__self__, "overlay_as", overlay_as)
        if overlay_as_variable is not None:
            pulumi.set(__self__, "overlay_as_variable", overlay_as_variable)
        if send_path_limit is not None:
            pulumi.set(__self__, "send_path_limit", send_path_limit)
        if send_path_limit_variable is not None:
            pulumi.set(__self__, "send_path_limit_variable", send_path_limit_variable)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if transport_gateway is not None:
            pulumi.set(__self__, "transport_gateway", transport_gateway)
        if transport_gateway_variable is not None:
            pulumi.set(__self__, "transport_gateway_variable", transport_gateway_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="advertiseIpv4Routes")
    def advertise_ipv4_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs']]]]:
        """
        Advertise locally learned routes to OMP
        """
        return pulumi.get(self, "advertise_ipv4_routes")

    @advertise_ipv4_routes.setter
    def advertise_ipv4_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs']]]]):
        pulumi.set(self, "advertise_ipv4_routes", value)

    @property
    @pulumi.getter(name="advertiseIpv6Routes")
    def advertise_ipv6_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs']]]]:
        """
        Advertise locally learned routes to OMP
        """
        return pulumi.get(self, "advertise_ipv6_routes")

    @advertise_ipv6_routes.setter
    def advertise_ipv6_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs']]]]):
        pulumi.set(self, "advertise_ipv6_routes", value)

    @property
    @pulumi.getter(name="advertisementInterval")
    def advertisement_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Set the time between OMP Update packets - Range: `0`-`65535` - Default value: `1`
        """
        return pulumi.get(self, "advertisement_interval")

    @advertisement_interval.setter
    def advertisement_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "advertisement_interval", value)

    @property
    @pulumi.getter(name="advertisementIntervalVariable")
    def advertisement_interval_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "advertisement_interval_variable")

    @advertisement_interval_variable.setter
    def advertisement_interval_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "advertisement_interval_variable", value)

    @property
    @pulumi.getter(name="ecmpLimit")
    def ecmp_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Set maximum number of OMP paths to install in vEdge route table - Range: `1`-`16` - Default value: `4`
        """
        return pulumi.get(self, "ecmp_limit")

    @ecmp_limit.setter
    def ecmp_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ecmp_limit", value)

    @property
    @pulumi.getter(name="ecmpLimitVariable")
    def ecmp_limit_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ecmp_limit_variable")

    @ecmp_limit_variable.setter
    def ecmp_limit_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecmp_limit_variable", value)

    @property
    @pulumi.getter(name="eorTimer")
    def eor_timer(self) -> Optional[pulumi.Input[int]]:
        """
        End of RIB timer <1..604800> seconds - Range: `1`-`3600` - Default value: `300`
        """
        return pulumi.get(self, "eor_timer")

    @eor_timer.setter
    def eor_timer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eor_timer", value)

    @property
    @pulumi.getter(name="eorTimerVariable")
    def eor_timer_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "eor_timer_variable")

    @eor_timer_variable.setter
    def eor_timer_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eor_timer_variable", value)

    @property
    @pulumi.getter(name="gracefulRestart")
    def graceful_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable OMP graceful restart - Default value: `true`
        """
        return pulumi.get(self, "graceful_restart")

    @graceful_restart.setter
    def graceful_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "graceful_restart", value)

    @property
    @pulumi.getter(name="gracefulRestartTimer")
    def graceful_restart_timer(self) -> Optional[pulumi.Input[int]]:
        """
        Set the OMP graceful restart timer - Range: `1`-`604800` - Default value: `43200`
        """
        return pulumi.get(self, "graceful_restart_timer")

    @graceful_restart_timer.setter
    def graceful_restart_timer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "graceful_restart_timer", value)

    @property
    @pulumi.getter(name="gracefulRestartTimerVariable")
    def graceful_restart_timer_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "graceful_restart_timer_variable")

    @graceful_restart_timer_variable.setter
    def graceful_restart_timer_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graceful_restart_timer_variable", value)

    @property
    @pulumi.getter(name="gracefulRestartVariable")
    def graceful_restart_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "graceful_restart_variable")

    @graceful_restart_variable.setter
    def graceful_restart_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graceful_restart_variable", value)

    @property
    @pulumi.getter
    def holdtime(self) -> Optional[pulumi.Input[int]]:
        """
        Set how long to wait before closing OMP peer connection - Default value: `60`
        """
        return pulumi.get(self, "holdtime")

    @holdtime.setter
    def holdtime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "holdtime", value)

    @property
    @pulumi.getter(name="holdtimeVariable")
    def holdtime_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "holdtime_variable")

    @holdtime_variable.setter
    def holdtime_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "holdtime_variable", value)

    @property
    @pulumi.getter(name="ignoreRegionPathLength")
    def ignore_region_path_length(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore Region-Path Length During Best-Path Algorithm - Default value: `false`
        """
        return pulumi.get(self, "ignore_region_path_length")

    @ignore_region_path_length.setter
    def ignore_region_path_length(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_region_path_length", value)

    @property
    @pulumi.getter(name="ignoreRegionPathLengthVariable")
    def ignore_region_path_length_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ignore_region_path_length_variable")

    @ignore_region_path_length_variable.setter
    def ignore_region_path_length_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ignore_region_path_length_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> Optional[pulumi.Input[int]]:
        """
        omp-admin-distance-ipv4 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @omp_admin_distance_ipv4.setter
    def omp_admin_distance_ipv4(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "omp_admin_distance_ipv4", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @omp_admin_distance_ipv4_variable.setter
    def omp_admin_distance_ipv4_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "omp_admin_distance_ipv4_variable", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> Optional[pulumi.Input[int]]:
        """
        omp-admin-distance-ipv6 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @omp_admin_distance_ipv6.setter
    def omp_admin_distance_ipv6(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "omp_admin_distance_ipv6", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @omp_admin_distance_ipv6_variable.setter
    def omp_admin_distance_ipv6_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "omp_admin_distance_ipv6_variable", value)

    @property
    @pulumi.getter(name="overlayAs")
    def overlay_as(self) -> Optional[pulumi.Input[int]]:
        """
        Set Overlay AS number <1..4294967295> or <XX.YY> - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "overlay_as")

    @overlay_as.setter
    def overlay_as(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "overlay_as", value)

    @property
    @pulumi.getter(name="overlayAsVariable")
    def overlay_as_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "overlay_as_variable")

    @overlay_as_variable.setter
    def overlay_as_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overlay_as_variable", value)

    @property
    @pulumi.getter(name="sendPathLimit")
    def send_path_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Set number of TLOC routes advertised between vSmart and vEdge - Range: `1`-`16` - Default value: `4`
        """
        return pulumi.get(self, "send_path_limit")

    @send_path_limit.setter
    def send_path_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "send_path_limit", value)

    @property
    @pulumi.getter(name="sendPathLimitVariable")
    def send_path_limit_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "send_path_limit_variable")

    @send_path_limit_variable.setter
    def send_path_limit_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "send_path_limit_variable", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable OMP - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="transportGateway")
    def transport_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        Transport gateway path computation - Choices: `prefer`, `ecmp-with-direct-path`
        """
        return pulumi.get(self, "transport_gateway")

    @transport_gateway.setter
    def transport_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transport_gateway", value)

    @property
    @pulumi.getter(name="transportGatewayVariable")
    def transport_gateway_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "transport_gateway_variable")

    @transport_gateway_variable.setter
    def transport_gateway_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transport_gateway_variable", value)


@pulumi.input_type
class _CiscoOmpFeatureTemplateState:
    def __init__(__self__, *,
                 advertise_ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs']]]] = None,
                 advertise_ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs']]]] = None,
                 advertisement_interval: Optional[pulumi.Input[int]] = None,
                 advertisement_interval_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ecmp_limit: Optional[pulumi.Input[int]] = None,
                 ecmp_limit_variable: Optional[pulumi.Input[str]] = None,
                 eor_timer: Optional[pulumi.Input[int]] = None,
                 eor_timer_variable: Optional[pulumi.Input[str]] = None,
                 graceful_restart: Optional[pulumi.Input[bool]] = None,
                 graceful_restart_timer: Optional[pulumi.Input[int]] = None,
                 graceful_restart_timer_variable: Optional[pulumi.Input[str]] = None,
                 graceful_restart_variable: Optional[pulumi.Input[str]] = None,
                 holdtime: Optional[pulumi.Input[int]] = None,
                 holdtime_variable: Optional[pulumi.Input[str]] = None,
                 ignore_region_path_length: Optional[pulumi.Input[bool]] = None,
                 ignore_region_path_length_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 overlay_as: Optional[pulumi.Input[int]] = None,
                 overlay_as_variable: Optional[pulumi.Input[str]] = None,
                 send_path_limit: Optional[pulumi.Input[int]] = None,
                 send_path_limit_variable: Optional[pulumi.Input[str]] = None,
                 shutdown: Optional[pulumi.Input[bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 transport_gateway: Optional[pulumi.Input[str]] = None,
                 transport_gateway_variable: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CiscoOmpFeatureTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs']]] advertise_ipv4_routes: Advertise locally learned routes to OMP
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs']]] advertise_ipv6_routes: Advertise locally learned routes to OMP
        :param pulumi.Input[int] advertisement_interval: Set the time between OMP Update packets - Range: `0`-`65535` - Default value: `1`
        :param pulumi.Input[str] advertisement_interval_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[int] ecmp_limit: Set maximum number of OMP paths to install in vEdge route table - Range: `1`-`16` - Default value: `4`
        :param pulumi.Input[str] ecmp_limit_variable: Variable name
        :param pulumi.Input[int] eor_timer: End of RIB timer <1..604800> seconds - Range: `1`-`3600` - Default value: `300`
        :param pulumi.Input[str] eor_timer_variable: Variable name
        :param pulumi.Input[bool] graceful_restart: Enable or disable OMP graceful restart - Default value: `true`
        :param pulumi.Input[int] graceful_restart_timer: Set the OMP graceful restart timer - Range: `1`-`604800` - Default value: `43200`
        :param pulumi.Input[str] graceful_restart_timer_variable: Variable name
        :param pulumi.Input[str] graceful_restart_variable: Variable name
        :param pulumi.Input[int] holdtime: Set how long to wait before closing OMP peer connection - Default value: `60`
        :param pulumi.Input[str] holdtime_variable: Variable name
        :param pulumi.Input[bool] ignore_region_path_length: Ignore Region-Path Length During Best-Path Algorithm - Default value: `false`
        :param pulumi.Input[str] ignore_region_path_length_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] omp_admin_distance_ipv4: omp-admin-distance-ipv4 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[int] omp_admin_distance_ipv6: omp-admin-distance-ipv6 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[int] overlay_as: Set Overlay AS number <1..4294967295> or <XX.YY> - Range: `1`-`4294967295`
        :param pulumi.Input[str] overlay_as_variable: Variable name
        :param pulumi.Input[int] send_path_limit: Set number of TLOC routes advertised between vSmart and vEdge - Range: `1`-`16` - Default value: `4`
        :param pulumi.Input[str] send_path_limit_variable: Variable name
        :param pulumi.Input[bool] shutdown: Enable or disable OMP - Default value: `false`
        :param pulumi.Input[str] shutdown_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[str] transport_gateway: Transport gateway path computation - Choices: `prefer`, `ecmp-with-direct-path`
        :param pulumi.Input[str] transport_gateway_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        if advertise_ipv4_routes is not None:
            pulumi.set(__self__, "advertise_ipv4_routes", advertise_ipv4_routes)
        if advertise_ipv6_routes is not None:
            pulumi.set(__self__, "advertise_ipv6_routes", advertise_ipv6_routes)
        if advertisement_interval is not None:
            pulumi.set(__self__, "advertisement_interval", advertisement_interval)
        if advertisement_interval_variable is not None:
            pulumi.set(__self__, "advertisement_interval_variable", advertisement_interval_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if ecmp_limit is not None:
            pulumi.set(__self__, "ecmp_limit", ecmp_limit)
        if ecmp_limit_variable is not None:
            pulumi.set(__self__, "ecmp_limit_variable", ecmp_limit_variable)
        if eor_timer is not None:
            pulumi.set(__self__, "eor_timer", eor_timer)
        if eor_timer_variable is not None:
            pulumi.set(__self__, "eor_timer_variable", eor_timer_variable)
        if graceful_restart is not None:
            pulumi.set(__self__, "graceful_restart", graceful_restart)
        if graceful_restart_timer is not None:
            pulumi.set(__self__, "graceful_restart_timer", graceful_restart_timer)
        if graceful_restart_timer_variable is not None:
            pulumi.set(__self__, "graceful_restart_timer_variable", graceful_restart_timer_variable)
        if graceful_restart_variable is not None:
            pulumi.set(__self__, "graceful_restart_variable", graceful_restart_variable)
        if holdtime is not None:
            pulumi.set(__self__, "holdtime", holdtime)
        if holdtime_variable is not None:
            pulumi.set(__self__, "holdtime_variable", holdtime_variable)
        if ignore_region_path_length is not None:
            pulumi.set(__self__, "ignore_region_path_length", ignore_region_path_length)
        if ignore_region_path_length_variable is not None:
            pulumi.set(__self__, "ignore_region_path_length_variable", ignore_region_path_length_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if omp_admin_distance_ipv4 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4", omp_admin_distance_ipv4)
        if omp_admin_distance_ipv4_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4_variable", omp_admin_distance_ipv4_variable)
        if omp_admin_distance_ipv6 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6", omp_admin_distance_ipv6)
        if omp_admin_distance_ipv6_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6_variable", omp_admin_distance_ipv6_variable)
        if overlay_as is not None:
            pulumi.set(__self__, "overlay_as", overlay_as)
        if overlay_as_variable is not None:
            pulumi.set(__self__, "overlay_as_variable", overlay_as_variable)
        if send_path_limit is not None:
            pulumi.set(__self__, "send_path_limit", send_path_limit)
        if send_path_limit_variable is not None:
            pulumi.set(__self__, "send_path_limit_variable", send_path_limit_variable)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if transport_gateway is not None:
            pulumi.set(__self__, "transport_gateway", transport_gateway)
        if transport_gateway_variable is not None:
            pulumi.set(__self__, "transport_gateway_variable", transport_gateway_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="advertiseIpv4Routes")
    def advertise_ipv4_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs']]]]:
        """
        Advertise locally learned routes to OMP
        """
        return pulumi.get(self, "advertise_ipv4_routes")

    @advertise_ipv4_routes.setter
    def advertise_ipv4_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs']]]]):
        pulumi.set(self, "advertise_ipv4_routes", value)

    @property
    @pulumi.getter(name="advertiseIpv6Routes")
    def advertise_ipv6_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs']]]]:
        """
        Advertise locally learned routes to OMP
        """
        return pulumi.get(self, "advertise_ipv6_routes")

    @advertise_ipv6_routes.setter
    def advertise_ipv6_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs']]]]):
        pulumi.set(self, "advertise_ipv6_routes", value)

    @property
    @pulumi.getter(name="advertisementInterval")
    def advertisement_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Set the time between OMP Update packets - Range: `0`-`65535` - Default value: `1`
        """
        return pulumi.get(self, "advertisement_interval")

    @advertisement_interval.setter
    def advertisement_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "advertisement_interval", value)

    @property
    @pulumi.getter(name="advertisementIntervalVariable")
    def advertisement_interval_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "advertisement_interval_variable")

    @advertisement_interval_variable.setter
    def advertisement_interval_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "advertisement_interval_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="ecmpLimit")
    def ecmp_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Set maximum number of OMP paths to install in vEdge route table - Range: `1`-`16` - Default value: `4`
        """
        return pulumi.get(self, "ecmp_limit")

    @ecmp_limit.setter
    def ecmp_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ecmp_limit", value)

    @property
    @pulumi.getter(name="ecmpLimitVariable")
    def ecmp_limit_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ecmp_limit_variable")

    @ecmp_limit_variable.setter
    def ecmp_limit_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecmp_limit_variable", value)

    @property
    @pulumi.getter(name="eorTimer")
    def eor_timer(self) -> Optional[pulumi.Input[int]]:
        """
        End of RIB timer <1..604800> seconds - Range: `1`-`3600` - Default value: `300`
        """
        return pulumi.get(self, "eor_timer")

    @eor_timer.setter
    def eor_timer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eor_timer", value)

    @property
    @pulumi.getter(name="eorTimerVariable")
    def eor_timer_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "eor_timer_variable")

    @eor_timer_variable.setter
    def eor_timer_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eor_timer_variable", value)

    @property
    @pulumi.getter(name="gracefulRestart")
    def graceful_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable OMP graceful restart - Default value: `true`
        """
        return pulumi.get(self, "graceful_restart")

    @graceful_restart.setter
    def graceful_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "graceful_restart", value)

    @property
    @pulumi.getter(name="gracefulRestartTimer")
    def graceful_restart_timer(self) -> Optional[pulumi.Input[int]]:
        """
        Set the OMP graceful restart timer - Range: `1`-`604800` - Default value: `43200`
        """
        return pulumi.get(self, "graceful_restart_timer")

    @graceful_restart_timer.setter
    def graceful_restart_timer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "graceful_restart_timer", value)

    @property
    @pulumi.getter(name="gracefulRestartTimerVariable")
    def graceful_restart_timer_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "graceful_restart_timer_variable")

    @graceful_restart_timer_variable.setter
    def graceful_restart_timer_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graceful_restart_timer_variable", value)

    @property
    @pulumi.getter(name="gracefulRestartVariable")
    def graceful_restart_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "graceful_restart_variable")

    @graceful_restart_variable.setter
    def graceful_restart_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graceful_restart_variable", value)

    @property
    @pulumi.getter
    def holdtime(self) -> Optional[pulumi.Input[int]]:
        """
        Set how long to wait before closing OMP peer connection - Default value: `60`
        """
        return pulumi.get(self, "holdtime")

    @holdtime.setter
    def holdtime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "holdtime", value)

    @property
    @pulumi.getter(name="holdtimeVariable")
    def holdtime_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "holdtime_variable")

    @holdtime_variable.setter
    def holdtime_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "holdtime_variable", value)

    @property
    @pulumi.getter(name="ignoreRegionPathLength")
    def ignore_region_path_length(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore Region-Path Length During Best-Path Algorithm - Default value: `false`
        """
        return pulumi.get(self, "ignore_region_path_length")

    @ignore_region_path_length.setter
    def ignore_region_path_length(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_region_path_length", value)

    @property
    @pulumi.getter(name="ignoreRegionPathLengthVariable")
    def ignore_region_path_length_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ignore_region_path_length_variable")

    @ignore_region_path_length_variable.setter
    def ignore_region_path_length_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ignore_region_path_length_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> Optional[pulumi.Input[int]]:
        """
        omp-admin-distance-ipv4 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @omp_admin_distance_ipv4.setter
    def omp_admin_distance_ipv4(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "omp_admin_distance_ipv4", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @omp_admin_distance_ipv4_variable.setter
    def omp_admin_distance_ipv4_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "omp_admin_distance_ipv4_variable", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> Optional[pulumi.Input[int]]:
        """
        omp-admin-distance-ipv6 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @omp_admin_distance_ipv6.setter
    def omp_admin_distance_ipv6(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "omp_admin_distance_ipv6", value)

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @omp_admin_distance_ipv6_variable.setter
    def omp_admin_distance_ipv6_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "omp_admin_distance_ipv6_variable", value)

    @property
    @pulumi.getter(name="overlayAs")
    def overlay_as(self) -> Optional[pulumi.Input[int]]:
        """
        Set Overlay AS number <1..4294967295> or <XX.YY> - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "overlay_as")

    @overlay_as.setter
    def overlay_as(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "overlay_as", value)

    @property
    @pulumi.getter(name="overlayAsVariable")
    def overlay_as_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "overlay_as_variable")

    @overlay_as_variable.setter
    def overlay_as_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overlay_as_variable", value)

    @property
    @pulumi.getter(name="sendPathLimit")
    def send_path_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Set number of TLOC routes advertised between vSmart and vEdge - Range: `1`-`16` - Default value: `4`
        """
        return pulumi.get(self, "send_path_limit")

    @send_path_limit.setter
    def send_path_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "send_path_limit", value)

    @property
    @pulumi.getter(name="sendPathLimitVariable")
    def send_path_limit_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "send_path_limit_variable")

    @send_path_limit_variable.setter
    def send_path_limit_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "send_path_limit_variable", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable OMP - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="transportGateway")
    def transport_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        Transport gateway path computation - Choices: `prefer`, `ecmp-with-direct-path`
        """
        return pulumi.get(self, "transport_gateway")

    @transport_gateway.setter
    def transport_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transport_gateway", value)

    @property
    @pulumi.getter(name="transportGatewayVariable")
    def transport_gateway_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "transport_gateway_variable")

    @transport_gateway_variable.setter
    def transport_gateway_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transport_gateway_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CiscoOmpFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs', 'CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgsDict']]]]] = None,
                 advertise_ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs', 'CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgsDict']]]]] = None,
                 advertisement_interval: Optional[pulumi.Input[int]] = None,
                 advertisement_interval_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ecmp_limit: Optional[pulumi.Input[int]] = None,
                 ecmp_limit_variable: Optional[pulumi.Input[str]] = None,
                 eor_timer: Optional[pulumi.Input[int]] = None,
                 eor_timer_variable: Optional[pulumi.Input[str]] = None,
                 graceful_restart: Optional[pulumi.Input[bool]] = None,
                 graceful_restart_timer: Optional[pulumi.Input[int]] = None,
                 graceful_restart_timer_variable: Optional[pulumi.Input[str]] = None,
                 graceful_restart_variable: Optional[pulumi.Input[str]] = None,
                 holdtime: Optional[pulumi.Input[int]] = None,
                 holdtime_variable: Optional[pulumi.Input[str]] = None,
                 ignore_region_path_length: Optional[pulumi.Input[bool]] = None,
                 ignore_region_path_length_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 overlay_as: Optional[pulumi.Input[int]] = None,
                 overlay_as_variable: Optional[pulumi.Input[str]] = None,
                 send_path_limit: Optional[pulumi.Input[int]] = None,
                 send_path_limit_variable: Optional[pulumi.Input[str]] = None,
                 shutdown: Optional[pulumi.Input[bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[str]] = None,
                 transport_gateway: Optional[pulumi.Input[str]] = None,
                 transport_gateway_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco OMP feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoOmpFeatureTemplate:CiscoOmpFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs', 'CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgsDict']]]] advertise_ipv4_routes: Advertise locally learned routes to OMP
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs', 'CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgsDict']]]] advertise_ipv6_routes: Advertise locally learned routes to OMP
        :param pulumi.Input[int] advertisement_interval: Set the time between OMP Update packets - Range: `0`-`65535` - Default value: `1`
        :param pulumi.Input[str] advertisement_interval_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[int] ecmp_limit: Set maximum number of OMP paths to install in vEdge route table - Range: `1`-`16` - Default value: `4`
        :param pulumi.Input[str] ecmp_limit_variable: Variable name
        :param pulumi.Input[int] eor_timer: End of RIB timer <1..604800> seconds - Range: `1`-`3600` - Default value: `300`
        :param pulumi.Input[str] eor_timer_variable: Variable name
        :param pulumi.Input[bool] graceful_restart: Enable or disable OMP graceful restart - Default value: `true`
        :param pulumi.Input[int] graceful_restart_timer: Set the OMP graceful restart timer - Range: `1`-`604800` - Default value: `43200`
        :param pulumi.Input[str] graceful_restart_timer_variable: Variable name
        :param pulumi.Input[str] graceful_restart_variable: Variable name
        :param pulumi.Input[int] holdtime: Set how long to wait before closing OMP peer connection - Default value: `60`
        :param pulumi.Input[str] holdtime_variable: Variable name
        :param pulumi.Input[bool] ignore_region_path_length: Ignore Region-Path Length During Best-Path Algorithm - Default value: `false`
        :param pulumi.Input[str] ignore_region_path_length_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] omp_admin_distance_ipv4: omp-admin-distance-ipv4 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[int] omp_admin_distance_ipv6: omp-admin-distance-ipv6 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[int] overlay_as: Set Overlay AS number <1..4294967295> or <XX.YY> - Range: `1`-`4294967295`
        :param pulumi.Input[str] overlay_as_variable: Variable name
        :param pulumi.Input[int] send_path_limit: Set number of TLOC routes advertised between vSmart and vEdge - Range: `1`-`16` - Default value: `4`
        :param pulumi.Input[str] send_path_limit_variable: Variable name
        :param pulumi.Input[bool] shutdown: Enable or disable OMP - Default value: `false`
        :param pulumi.Input[str] shutdown_variable: Variable name
        :param pulumi.Input[str] transport_gateway: Transport gateway path computation - Choices: `prefer`, `ecmp-with-direct-path`
        :param pulumi.Input[str] transport_gateway_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoOmpFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco OMP feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoOmpFeatureTemplate:CiscoOmpFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoOmpFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoOmpFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs', 'CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgsDict']]]]] = None,
                 advertise_ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs', 'CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgsDict']]]]] = None,
                 advertisement_interval: Optional[pulumi.Input[int]] = None,
                 advertisement_interval_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ecmp_limit: Optional[pulumi.Input[int]] = None,
                 ecmp_limit_variable: Optional[pulumi.Input[str]] = None,
                 eor_timer: Optional[pulumi.Input[int]] = None,
                 eor_timer_variable: Optional[pulumi.Input[str]] = None,
                 graceful_restart: Optional[pulumi.Input[bool]] = None,
                 graceful_restart_timer: Optional[pulumi.Input[int]] = None,
                 graceful_restart_timer_variable: Optional[pulumi.Input[str]] = None,
                 graceful_restart_variable: Optional[pulumi.Input[str]] = None,
                 holdtime: Optional[pulumi.Input[int]] = None,
                 holdtime_variable: Optional[pulumi.Input[str]] = None,
                 ignore_region_path_length: Optional[pulumi.Input[bool]] = None,
                 ignore_region_path_length_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[str]] = None,
                 overlay_as: Optional[pulumi.Input[int]] = None,
                 overlay_as_variable: Optional[pulumi.Input[str]] = None,
                 send_path_limit: Optional[pulumi.Input[int]] = None,
                 send_path_limit_variable: Optional[pulumi.Input[str]] = None,
                 shutdown: Optional[pulumi.Input[bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[str]] = None,
                 transport_gateway: Optional[pulumi.Input[str]] = None,
                 transport_gateway_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoOmpFeatureTemplateArgs.__new__(CiscoOmpFeatureTemplateArgs)

            __props__.__dict__["advertise_ipv4_routes"] = advertise_ipv4_routes
            __props__.__dict__["advertise_ipv6_routes"] = advertise_ipv6_routes
            __props__.__dict__["advertisement_interval"] = advertisement_interval
            __props__.__dict__["advertisement_interval_variable"] = advertisement_interval_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["ecmp_limit"] = ecmp_limit
            __props__.__dict__["ecmp_limit_variable"] = ecmp_limit_variable
            __props__.__dict__["eor_timer"] = eor_timer
            __props__.__dict__["eor_timer_variable"] = eor_timer_variable
            __props__.__dict__["graceful_restart"] = graceful_restart
            __props__.__dict__["graceful_restart_timer"] = graceful_restart_timer
            __props__.__dict__["graceful_restart_timer_variable"] = graceful_restart_timer_variable
            __props__.__dict__["graceful_restart_variable"] = graceful_restart_variable
            __props__.__dict__["holdtime"] = holdtime
            __props__.__dict__["holdtime_variable"] = holdtime_variable
            __props__.__dict__["ignore_region_path_length"] = ignore_region_path_length
            __props__.__dict__["ignore_region_path_length_variable"] = ignore_region_path_length_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["omp_admin_distance_ipv4"] = omp_admin_distance_ipv4
            __props__.__dict__["omp_admin_distance_ipv4_variable"] = omp_admin_distance_ipv4_variable
            __props__.__dict__["omp_admin_distance_ipv6"] = omp_admin_distance_ipv6
            __props__.__dict__["omp_admin_distance_ipv6_variable"] = omp_admin_distance_ipv6_variable
            __props__.__dict__["overlay_as"] = overlay_as
            __props__.__dict__["overlay_as_variable"] = overlay_as_variable
            __props__.__dict__["send_path_limit"] = send_path_limit
            __props__.__dict__["send_path_limit_variable"] = send_path_limit_variable
            __props__.__dict__["shutdown"] = shutdown
            __props__.__dict__["shutdown_variable"] = shutdown_variable
            __props__.__dict__["transport_gateway"] = transport_gateway
            __props__.__dict__["transport_gateway_variable"] = transport_gateway_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoOmpFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoOmpFeatureTemplate:CiscoOmpFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advertise_ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs', 'CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgsDict']]]]] = None,
            advertise_ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs', 'CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgsDict']]]]] = None,
            advertisement_interval: Optional[pulumi.Input[int]] = None,
            advertisement_interval_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ecmp_limit: Optional[pulumi.Input[int]] = None,
            ecmp_limit_variable: Optional[pulumi.Input[str]] = None,
            eor_timer: Optional[pulumi.Input[int]] = None,
            eor_timer_variable: Optional[pulumi.Input[str]] = None,
            graceful_restart: Optional[pulumi.Input[bool]] = None,
            graceful_restart_timer: Optional[pulumi.Input[int]] = None,
            graceful_restart_timer_variable: Optional[pulumi.Input[str]] = None,
            graceful_restart_variable: Optional[pulumi.Input[str]] = None,
            holdtime: Optional[pulumi.Input[int]] = None,
            holdtime_variable: Optional[pulumi.Input[str]] = None,
            ignore_region_path_length: Optional[pulumi.Input[bool]] = None,
            ignore_region_path_length_variable: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            omp_admin_distance_ipv4: Optional[pulumi.Input[int]] = None,
            omp_admin_distance_ipv4_variable: Optional[pulumi.Input[str]] = None,
            omp_admin_distance_ipv6: Optional[pulumi.Input[int]] = None,
            omp_admin_distance_ipv6_variable: Optional[pulumi.Input[str]] = None,
            overlay_as: Optional[pulumi.Input[int]] = None,
            overlay_as_variable: Optional[pulumi.Input[str]] = None,
            send_path_limit: Optional[pulumi.Input[int]] = None,
            send_path_limit_variable: Optional[pulumi.Input[str]] = None,
            shutdown: Optional[pulumi.Input[bool]] = None,
            shutdown_variable: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            transport_gateway: Optional[pulumi.Input[str]] = None,
            transport_gateway_variable: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CiscoOmpFeatureTemplate':
        """
        Get an existing CiscoOmpFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgs', 'CiscoOmpFeatureTemplateAdvertiseIpv4RouteArgsDict']]]] advertise_ipv4_routes: Advertise locally learned routes to OMP
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgs', 'CiscoOmpFeatureTemplateAdvertiseIpv6RouteArgsDict']]]] advertise_ipv6_routes: Advertise locally learned routes to OMP
        :param pulumi.Input[int] advertisement_interval: Set the time between OMP Update packets - Range: `0`-`65535` - Default value: `1`
        :param pulumi.Input[str] advertisement_interval_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[int] ecmp_limit: Set maximum number of OMP paths to install in vEdge route table - Range: `1`-`16` - Default value: `4`
        :param pulumi.Input[str] ecmp_limit_variable: Variable name
        :param pulumi.Input[int] eor_timer: End of RIB timer <1..604800> seconds - Range: `1`-`3600` - Default value: `300`
        :param pulumi.Input[str] eor_timer_variable: Variable name
        :param pulumi.Input[bool] graceful_restart: Enable or disable OMP graceful restart - Default value: `true`
        :param pulumi.Input[int] graceful_restart_timer: Set the OMP graceful restart timer - Range: `1`-`604800` - Default value: `43200`
        :param pulumi.Input[str] graceful_restart_timer_variable: Variable name
        :param pulumi.Input[str] graceful_restart_variable: Variable name
        :param pulumi.Input[int] holdtime: Set how long to wait before closing OMP peer connection - Default value: `60`
        :param pulumi.Input[str] holdtime_variable: Variable name
        :param pulumi.Input[bool] ignore_region_path_length: Ignore Region-Path Length During Best-Path Algorithm - Default value: `false`
        :param pulumi.Input[str] ignore_region_path_length_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[int] omp_admin_distance_ipv4: omp-admin-distance-ipv4 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[int] omp_admin_distance_ipv6: omp-admin-distance-ipv6 - Range: `1`-`255`
        :param pulumi.Input[str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[int] overlay_as: Set Overlay AS number <1..4294967295> or <XX.YY> - Range: `1`-`4294967295`
        :param pulumi.Input[str] overlay_as_variable: Variable name
        :param pulumi.Input[int] send_path_limit: Set number of TLOC routes advertised between vSmart and vEdge - Range: `1`-`16` - Default value: `4`
        :param pulumi.Input[str] send_path_limit_variable: Variable name
        :param pulumi.Input[bool] shutdown: Enable or disable OMP - Default value: `false`
        :param pulumi.Input[str] shutdown_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[str] transport_gateway: Transport gateway path computation - Choices: `prefer`, `ecmp-with-direct-path`
        :param pulumi.Input[str] transport_gateway_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoOmpFeatureTemplateState.__new__(_CiscoOmpFeatureTemplateState)

        __props__.__dict__["advertise_ipv4_routes"] = advertise_ipv4_routes
        __props__.__dict__["advertise_ipv6_routes"] = advertise_ipv6_routes
        __props__.__dict__["advertisement_interval"] = advertisement_interval
        __props__.__dict__["advertisement_interval_variable"] = advertisement_interval_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["ecmp_limit"] = ecmp_limit
        __props__.__dict__["ecmp_limit_variable"] = ecmp_limit_variable
        __props__.__dict__["eor_timer"] = eor_timer
        __props__.__dict__["eor_timer_variable"] = eor_timer_variable
        __props__.__dict__["graceful_restart"] = graceful_restart
        __props__.__dict__["graceful_restart_timer"] = graceful_restart_timer
        __props__.__dict__["graceful_restart_timer_variable"] = graceful_restart_timer_variable
        __props__.__dict__["graceful_restart_variable"] = graceful_restart_variable
        __props__.__dict__["holdtime"] = holdtime
        __props__.__dict__["holdtime_variable"] = holdtime_variable
        __props__.__dict__["ignore_region_path_length"] = ignore_region_path_length
        __props__.__dict__["ignore_region_path_length_variable"] = ignore_region_path_length_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["omp_admin_distance_ipv4"] = omp_admin_distance_ipv4
        __props__.__dict__["omp_admin_distance_ipv4_variable"] = omp_admin_distance_ipv4_variable
        __props__.__dict__["omp_admin_distance_ipv6"] = omp_admin_distance_ipv6
        __props__.__dict__["omp_admin_distance_ipv6_variable"] = omp_admin_distance_ipv6_variable
        __props__.__dict__["overlay_as"] = overlay_as
        __props__.__dict__["overlay_as_variable"] = overlay_as_variable
        __props__.__dict__["send_path_limit"] = send_path_limit
        __props__.__dict__["send_path_limit_variable"] = send_path_limit_variable
        __props__.__dict__["shutdown"] = shutdown
        __props__.__dict__["shutdown_variable"] = shutdown_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["transport_gateway"] = transport_gateway
        __props__.__dict__["transport_gateway_variable"] = transport_gateway_variable
        __props__.__dict__["version"] = version
        return CiscoOmpFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advertiseIpv4Routes")
    def advertise_ipv4_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOmpFeatureTemplateAdvertiseIpv4Route']]]:
        """
        Advertise locally learned routes to OMP
        """
        return pulumi.get(self, "advertise_ipv4_routes")

    @property
    @pulumi.getter(name="advertiseIpv6Routes")
    def advertise_ipv6_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOmpFeatureTemplateAdvertiseIpv6Route']]]:
        """
        Advertise locally learned routes to OMP
        """
        return pulumi.get(self, "advertise_ipv6_routes")

    @property
    @pulumi.getter(name="advertisementInterval")
    def advertisement_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Set the time between OMP Update packets - Range: `0`-`65535` - Default value: `1`
        """
        return pulumi.get(self, "advertisement_interval")

    @property
    @pulumi.getter(name="advertisementIntervalVariable")
    def advertisement_interval_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "advertisement_interval_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="ecmpLimit")
    def ecmp_limit(self) -> pulumi.Output[Optional[int]]:
        """
        Set maximum number of OMP paths to install in vEdge route table - Range: `1`-`16` - Default value: `4`
        """
        return pulumi.get(self, "ecmp_limit")

    @property
    @pulumi.getter(name="ecmpLimitVariable")
    def ecmp_limit_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ecmp_limit_variable")

    @property
    @pulumi.getter(name="eorTimer")
    def eor_timer(self) -> pulumi.Output[Optional[int]]:
        """
        End of RIB timer <1..604800> seconds - Range: `1`-`3600` - Default value: `300`
        """
        return pulumi.get(self, "eor_timer")

    @property
    @pulumi.getter(name="eorTimerVariable")
    def eor_timer_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "eor_timer_variable")

    @property
    @pulumi.getter(name="gracefulRestart")
    def graceful_restart(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable OMP graceful restart - Default value: `true`
        """
        return pulumi.get(self, "graceful_restart")

    @property
    @pulumi.getter(name="gracefulRestartTimer")
    def graceful_restart_timer(self) -> pulumi.Output[Optional[int]]:
        """
        Set the OMP graceful restart timer - Range: `1`-`604800` - Default value: `43200`
        """
        return pulumi.get(self, "graceful_restart_timer")

    @property
    @pulumi.getter(name="gracefulRestartTimerVariable")
    def graceful_restart_timer_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "graceful_restart_timer_variable")

    @property
    @pulumi.getter(name="gracefulRestartVariable")
    def graceful_restart_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "graceful_restart_variable")

    @property
    @pulumi.getter
    def holdtime(self) -> pulumi.Output[Optional[int]]:
        """
        Set how long to wait before closing OMP peer connection - Default value: `60`
        """
        return pulumi.get(self, "holdtime")

    @property
    @pulumi.getter(name="holdtimeVariable")
    def holdtime_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "holdtime_variable")

    @property
    @pulumi.getter(name="ignoreRegionPathLength")
    def ignore_region_path_length(self) -> pulumi.Output[Optional[bool]]:
        """
        Ignore Region-Path Length During Best-Path Algorithm - Default value: `false`
        """
        return pulumi.get(self, "ignore_region_path_length")

    @property
    @pulumi.getter(name="ignoreRegionPathLengthVariable")
    def ignore_region_path_length_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ignore_region_path_length_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> pulumi.Output[Optional[int]]:
        """
        omp-admin-distance-ipv4 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> pulumi.Output[Optional[int]]:
        """
        omp-admin-distance-ipv6 - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @property
    @pulumi.getter(name="overlayAs")
    def overlay_as(self) -> pulumi.Output[Optional[int]]:
        """
        Set Overlay AS number <1..4294967295> or <XX.YY> - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "overlay_as")

    @property
    @pulumi.getter(name="overlayAsVariable")
    def overlay_as_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "overlay_as_variable")

    @property
    @pulumi.getter(name="sendPathLimit")
    def send_path_limit(self) -> pulumi.Output[Optional[int]]:
        """
        Set number of TLOC routes advertised between vSmart and vEdge - Range: `1`-`16` - Default value: `4`
        """
        return pulumi.get(self, "send_path_limit")

    @property
    @pulumi.getter(name="sendPathLimitVariable")
    def send_path_limit_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "send_path_limit_variable")

    @property
    @pulumi.getter
    def shutdown(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable OMP - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="transportGateway")
    def transport_gateway(self) -> pulumi.Output[Optional[str]]:
        """
        Transport gateway path computation - Choices: `prefer`, `ecmp-with-direct-path`
        """
        return pulumi.get(self, "transport_gateway")

    @property
    @pulumi.getter(name="transportGatewayVariable")
    def transport_gateway_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "transport_gateway_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

