# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoVpnInterfaceGreFeatureTemplateArgs', 'CiscoVpnInterfaceGreFeatureTemplate']

@pulumi.input_type
class CiscoVpnInterfaceGreFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 access_lists: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs']]]] = None,
                 application: Optional[pulumi.Input[str]] = None,
                 application_variable: Optional[pulumi.Input[str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[str]] = None,
                 interface_description: Optional[pulumi.Input[str]] = None,
                 interface_description_variable: Optional[pulumi.Input[str]] = None,
                 interface_name: Optional[pulumi.Input[str]] = None,
                 interface_name_variable: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_address_variable: Optional[pulumi.Input[str]] = None,
                 ip_mtu: Optional[pulumi.Input[int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rewrite_rule: Optional[pulumi.Input[str]] = None,
                 rewrite_rule_variable: Optional[pulumi.Input[str]] = None,
                 shutdown: Optional[pulumi.Input[bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[str]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[str]] = None,
                 tracker_variable: Optional[pulumi.Input[str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tunnel_destination: Optional[pulumi.Input[str]] = None,
                 tunnel_destination_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_route_via: Optional[pulumi.Input[str]] = None,
                 tunnel_route_via_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_source: Optional[pulumi.Input[str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_source_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CiscoVpnInterfaceGreFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs']]] access_lists: Apply ACL
        :param pulumi.Input[str] application: Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        :param pulumi.Input[str] application_variable: Variable name
        :param pulumi.Input[bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[str] interface_description: Interface description
        :param pulumi.Input[str] interface_description_variable: Variable name
        :param pulumi.Input[str] interface_name: Interface name: ge0/<0-..> or ge0/<0-..>.vlanid or irb<bridgeid:1-63> or loopback<string> or natpool-<1..31> when
               present
        :param pulumi.Input[str] interface_name_variable: Variable name
        :param pulumi.Input[str] ip_address: Assign IPv4 address
        :param pulumi.Input[str] ip_address_variable: Variable name
        :param pulumi.Input[int] ip_mtu: Interface MTU <576..2000>, in bytes - Range: `64`-`18000` - Default value: `1500`
        :param pulumi.Input[str] ip_mtu_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] rewrite_rule: Name of rewrite rule
        :param pulumi.Input[str] rewrite_rule_variable: Variable name
        :param pulumi.Input[bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[str] shutdown_variable: Variable name
        :param pulumi.Input[int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[str] tcp_mss_adjust_variable: Variable name
        :param pulumi.Input[str] tracker_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trackers: Enable tracker for this interface
        :param pulumi.Input[str] tunnel_destination: Tunnel destination IP Address
        :param pulumi.Input[str] tunnel_destination_variable: Variable name
        :param pulumi.Input[str] tunnel_route_via: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[str] tunnel_route_via_variable: Variable name
        :param pulumi.Input[str] tunnel_source: Tunnel source IP Address
        :param pulumi.Input[str] tunnel_source_interface: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[str] tunnel_source_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if access_lists is not None:
            pulumi.set(__self__, "access_lists", access_lists)
        if application is not None:
            pulumi.set(__self__, "application", application)
        if application_variable is not None:
            pulumi.set(__self__, "application_variable", application_variable)
        if clear_dont_fragment is not None:
            pulumi.set(__self__, "clear_dont_fragment", clear_dont_fragment)
        if clear_dont_fragment_variable is not None:
            pulumi.set(__self__, "clear_dont_fragment_variable", clear_dont_fragment_variable)
        if interface_description is not None:
            pulumi.set(__self__, "interface_description", interface_description)
        if interface_description_variable is not None:
            pulumi.set(__self__, "interface_description_variable", interface_description_variable)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if interface_name_variable is not None:
            pulumi.set(__self__, "interface_name_variable", interface_name_variable)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_variable is not None:
            pulumi.set(__self__, "ip_address_variable", ip_address_variable)
        if ip_mtu is not None:
            pulumi.set(__self__, "ip_mtu", ip_mtu)
        if ip_mtu_variable is not None:
            pulumi.set(__self__, "ip_mtu_variable", ip_mtu_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rewrite_rule is not None:
            pulumi.set(__self__, "rewrite_rule", rewrite_rule)
        if rewrite_rule_variable is not None:
            pulumi.set(__self__, "rewrite_rule_variable", rewrite_rule_variable)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if tcp_mss_adjust is not None:
            pulumi.set(__self__, "tcp_mss_adjust", tcp_mss_adjust)
        if tcp_mss_adjust_variable is not None:
            pulumi.set(__self__, "tcp_mss_adjust_variable", tcp_mss_adjust_variable)
        if tracker_variable is not None:
            pulumi.set(__self__, "tracker_variable", tracker_variable)
        if trackers is not None:
            pulumi.set(__self__, "trackers", trackers)
        if tunnel_destination is not None:
            pulumi.set(__self__, "tunnel_destination", tunnel_destination)
        if tunnel_destination_variable is not None:
            pulumi.set(__self__, "tunnel_destination_variable", tunnel_destination_variable)
        if tunnel_route_via is not None:
            pulumi.set(__self__, "tunnel_route_via", tunnel_route_via)
        if tunnel_route_via_variable is not None:
            pulumi.set(__self__, "tunnel_route_via_variable", tunnel_route_via_variable)
        if tunnel_source is not None:
            pulumi.set(__self__, "tunnel_source", tunnel_source)
        if tunnel_source_interface is not None:
            pulumi.set(__self__, "tunnel_source_interface", tunnel_source_interface)
        if tunnel_source_interface_variable is not None:
            pulumi.set(__self__, "tunnel_source_interface_variable", tunnel_source_interface_variable)
        if tunnel_source_variable is not None:
            pulumi.set(__self__, "tunnel_source_variable", tunnel_source_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="accessLists")
    def access_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs']]]]:
        """
        Apply ACL
        """
        return pulumi.get(self, "access_lists")

    @access_lists.setter
    def access_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs']]]]):
        pulumi.set(self, "access_lists", value)

    @property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[str]]:
        """
        Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application", value)

    @property
    @pulumi.getter(name="applicationVariable")
    def application_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "application_variable")

    @application_variable.setter
    def application_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_variable", value)

    @property
    @pulumi.getter(name="clearDontFragment")
    def clear_dont_fragment(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        """
        return pulumi.get(self, "clear_dont_fragment")

    @clear_dont_fragment.setter
    def clear_dont_fragment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "clear_dont_fragment", value)

    @property
    @pulumi.getter(name="clearDontFragmentVariable")
    def clear_dont_fragment_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "clear_dont_fragment_variable")

    @clear_dont_fragment_variable.setter
    def clear_dont_fragment_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "clear_dont_fragment_variable", value)

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> Optional[pulumi.Input[str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @interface_description.setter
    def interface_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_description", value)

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @interface_description_variable.setter
    def interface_description_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_description_variable", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        Interface name: ge0/<0-..> or ge0/<0-..>.vlanid or irb<bridgeid:1-63> or loopback<string> or natpool-<1..31> when
        present
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @interface_name_variable.setter
    def interface_name_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_name_variable", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipAddressVariable")
    def ip_address_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_address_variable")

    @ip_address_variable.setter
    def ip_address_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address_variable", value)

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> Optional[pulumi.Input[int]]:
        """
        Interface MTU <576..2000>, in bytes - Range: `64`-`18000` - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @ip_mtu.setter
    def ip_mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_mtu", value)

    @property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @ip_mtu_variable.setter
    def ip_mtu_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_mtu_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rewriteRule")
    def rewrite_rule(self) -> Optional[pulumi.Input[str]]:
        """
        Name of rewrite rule
        """
        return pulumi.get(self, "rewrite_rule")

    @rewrite_rule.setter
    def rewrite_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rewrite_rule", value)

    @property
    @pulumi.getter(name="rewriteRuleVariable")
    def rewrite_rule_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rewrite_rule_variable")

    @rewrite_rule_variable.setter
    def rewrite_rule_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rewrite_rule_variable", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[bool]]:
        """
        Administrative state - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="tcpMssAdjust")
    def tcp_mss_adjust(self) -> Optional[pulumi.Input[int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        """
        return pulumi.get(self, "tcp_mss_adjust")

    @tcp_mss_adjust.setter
    def tcp_mss_adjust(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_mss_adjust", value)

    @property
    @pulumi.getter(name="tcpMssAdjustVariable")
    def tcp_mss_adjust_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_adjust_variable")

    @tcp_mss_adjust_variable.setter
    def tcp_mss_adjust_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_mss_adjust_variable", value)

    @property
    @pulumi.getter(name="trackerVariable")
    def tracker_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_variable")

    @tracker_variable.setter
    def tracker_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracker_variable", value)

    @property
    @pulumi.getter
    def trackers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Enable tracker for this interface
        """
        return pulumi.get(self, "trackers")

    @trackers.setter
    def trackers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trackers", value)

    @property
    @pulumi.getter(name="tunnelDestination")
    def tunnel_destination(self) -> Optional[pulumi.Input[str]]:
        """
        Tunnel destination IP Address
        """
        return pulumi.get(self, "tunnel_destination")

    @tunnel_destination.setter
    def tunnel_destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_destination", value)

    @property
    @pulumi.getter(name="tunnelDestinationVariable")
    def tunnel_destination_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_destination_variable")

    @tunnel_destination_variable.setter
    def tunnel_destination_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_destination_variable", value)

    @property
    @pulumi.getter(name="tunnelRouteVia")
    def tunnel_route_via(self) -> Optional[pulumi.Input[str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_route_via")

    @tunnel_route_via.setter
    def tunnel_route_via(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_route_via", value)

    @property
    @pulumi.getter(name="tunnelRouteViaVariable")
    def tunnel_route_via_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_route_via_variable")

    @tunnel_route_via_variable.setter
    def tunnel_route_via_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_route_via_variable", value)

    @property
    @pulumi.getter(name="tunnelSource")
    def tunnel_source(self) -> Optional[pulumi.Input[str]]:
        """
        Tunnel source IP Address
        """
        return pulumi.get(self, "tunnel_source")

    @tunnel_source.setter
    def tunnel_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_source", value)

    @property
    @pulumi.getter(name="tunnelSourceInterface")
    def tunnel_source_interface(self) -> Optional[pulumi.Input[str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_source_interface")

    @tunnel_source_interface.setter
    def tunnel_source_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_source_interface", value)

    @property
    @pulumi.getter(name="tunnelSourceInterfaceVariable")
    def tunnel_source_interface_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_variable")

    @tunnel_source_interface_variable.setter
    def tunnel_source_interface_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_source_interface_variable", value)

    @property
    @pulumi.getter(name="tunnelSourceVariable")
    def tunnel_source_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_variable")

    @tunnel_source_variable.setter
    def tunnel_source_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_source_variable", value)


@pulumi.input_type
class _CiscoVpnInterfaceGreFeatureTemplateState:
    def __init__(__self__, *,
                 access_lists: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs']]]] = None,
                 application: Optional[pulumi.Input[str]] = None,
                 application_variable: Optional[pulumi.Input[str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 interface_description: Optional[pulumi.Input[str]] = None,
                 interface_description_variable: Optional[pulumi.Input[str]] = None,
                 interface_name: Optional[pulumi.Input[str]] = None,
                 interface_name_variable: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_address_variable: Optional[pulumi.Input[str]] = None,
                 ip_mtu: Optional[pulumi.Input[int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rewrite_rule: Optional[pulumi.Input[str]] = None,
                 rewrite_rule_variable: Optional[pulumi.Input[str]] = None,
                 shutdown: Optional[pulumi.Input[bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[str]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 tracker_variable: Optional[pulumi.Input[str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tunnel_destination: Optional[pulumi.Input[str]] = None,
                 tunnel_destination_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_route_via: Optional[pulumi.Input[str]] = None,
                 tunnel_route_via_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_source: Optional[pulumi.Input[str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_source_variable: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CiscoVpnInterfaceGreFeatureTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs']]] access_lists: Apply ACL
        :param pulumi.Input[str] application: Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        :param pulumi.Input[str] application_variable: Variable name
        :param pulumi.Input[bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] interface_description: Interface description
        :param pulumi.Input[str] interface_description_variable: Variable name
        :param pulumi.Input[str] interface_name: Interface name: ge0/<0-..> or ge0/<0-..>.vlanid or irb<bridgeid:1-63> or loopback<string> or natpool-<1..31> when
               present
        :param pulumi.Input[str] interface_name_variable: Variable name
        :param pulumi.Input[str] ip_address: Assign IPv4 address
        :param pulumi.Input[str] ip_address_variable: Variable name
        :param pulumi.Input[int] ip_mtu: Interface MTU <576..2000>, in bytes - Range: `64`-`18000` - Default value: `1500`
        :param pulumi.Input[str] ip_mtu_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] rewrite_rule: Name of rewrite rule
        :param pulumi.Input[str] rewrite_rule_variable: Variable name
        :param pulumi.Input[bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[str] shutdown_variable: Variable name
        :param pulumi.Input[int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[str] tcp_mss_adjust_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[str] tracker_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trackers: Enable tracker for this interface
        :param pulumi.Input[str] tunnel_destination: Tunnel destination IP Address
        :param pulumi.Input[str] tunnel_destination_variable: Variable name
        :param pulumi.Input[str] tunnel_route_via: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[str] tunnel_route_via_variable: Variable name
        :param pulumi.Input[str] tunnel_source: Tunnel source IP Address
        :param pulumi.Input[str] tunnel_source_interface: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[str] tunnel_source_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        if access_lists is not None:
            pulumi.set(__self__, "access_lists", access_lists)
        if application is not None:
            pulumi.set(__self__, "application", application)
        if application_variable is not None:
            pulumi.set(__self__, "application_variable", application_variable)
        if clear_dont_fragment is not None:
            pulumi.set(__self__, "clear_dont_fragment", clear_dont_fragment)
        if clear_dont_fragment_variable is not None:
            pulumi.set(__self__, "clear_dont_fragment_variable", clear_dont_fragment_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if interface_description is not None:
            pulumi.set(__self__, "interface_description", interface_description)
        if interface_description_variable is not None:
            pulumi.set(__self__, "interface_description_variable", interface_description_variable)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if interface_name_variable is not None:
            pulumi.set(__self__, "interface_name_variable", interface_name_variable)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_variable is not None:
            pulumi.set(__self__, "ip_address_variable", ip_address_variable)
        if ip_mtu is not None:
            pulumi.set(__self__, "ip_mtu", ip_mtu)
        if ip_mtu_variable is not None:
            pulumi.set(__self__, "ip_mtu_variable", ip_mtu_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rewrite_rule is not None:
            pulumi.set(__self__, "rewrite_rule", rewrite_rule)
        if rewrite_rule_variable is not None:
            pulumi.set(__self__, "rewrite_rule_variable", rewrite_rule_variable)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if tcp_mss_adjust is not None:
            pulumi.set(__self__, "tcp_mss_adjust", tcp_mss_adjust)
        if tcp_mss_adjust_variable is not None:
            pulumi.set(__self__, "tcp_mss_adjust_variable", tcp_mss_adjust_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if tracker_variable is not None:
            pulumi.set(__self__, "tracker_variable", tracker_variable)
        if trackers is not None:
            pulumi.set(__self__, "trackers", trackers)
        if tunnel_destination is not None:
            pulumi.set(__self__, "tunnel_destination", tunnel_destination)
        if tunnel_destination_variable is not None:
            pulumi.set(__self__, "tunnel_destination_variable", tunnel_destination_variable)
        if tunnel_route_via is not None:
            pulumi.set(__self__, "tunnel_route_via", tunnel_route_via)
        if tunnel_route_via_variable is not None:
            pulumi.set(__self__, "tunnel_route_via_variable", tunnel_route_via_variable)
        if tunnel_source is not None:
            pulumi.set(__self__, "tunnel_source", tunnel_source)
        if tunnel_source_interface is not None:
            pulumi.set(__self__, "tunnel_source_interface", tunnel_source_interface)
        if tunnel_source_interface_variable is not None:
            pulumi.set(__self__, "tunnel_source_interface_variable", tunnel_source_interface_variable)
        if tunnel_source_variable is not None:
            pulumi.set(__self__, "tunnel_source_variable", tunnel_source_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="accessLists")
    def access_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs']]]]:
        """
        Apply ACL
        """
        return pulumi.get(self, "access_lists")

    @access_lists.setter
    def access_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs']]]]):
        pulumi.set(self, "access_lists", value)

    @property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[str]]:
        """
        Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application", value)

    @property
    @pulumi.getter(name="applicationVariable")
    def application_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "application_variable")

    @application_variable.setter
    def application_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_variable", value)

    @property
    @pulumi.getter(name="clearDontFragment")
    def clear_dont_fragment(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        """
        return pulumi.get(self, "clear_dont_fragment")

    @clear_dont_fragment.setter
    def clear_dont_fragment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "clear_dont_fragment", value)

    @property
    @pulumi.getter(name="clearDontFragmentVariable")
    def clear_dont_fragment_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "clear_dont_fragment_variable")

    @clear_dont_fragment_variable.setter
    def clear_dont_fragment_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "clear_dont_fragment_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> Optional[pulumi.Input[str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @interface_description.setter
    def interface_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_description", value)

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @interface_description_variable.setter
    def interface_description_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_description_variable", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        Interface name: ge0/<0-..> or ge0/<0-..>.vlanid or irb<bridgeid:1-63> or loopback<string> or natpool-<1..31> when
        present
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @interface_name_variable.setter
    def interface_name_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_name_variable", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipAddressVariable")
    def ip_address_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_address_variable")

    @ip_address_variable.setter
    def ip_address_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address_variable", value)

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> Optional[pulumi.Input[int]]:
        """
        Interface MTU <576..2000>, in bytes - Range: `64`-`18000` - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @ip_mtu.setter
    def ip_mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_mtu", value)

    @property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @ip_mtu_variable.setter
    def ip_mtu_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_mtu_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rewriteRule")
    def rewrite_rule(self) -> Optional[pulumi.Input[str]]:
        """
        Name of rewrite rule
        """
        return pulumi.get(self, "rewrite_rule")

    @rewrite_rule.setter
    def rewrite_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rewrite_rule", value)

    @property
    @pulumi.getter(name="rewriteRuleVariable")
    def rewrite_rule_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rewrite_rule_variable")

    @rewrite_rule_variable.setter
    def rewrite_rule_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rewrite_rule_variable", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[bool]]:
        """
        Administrative state - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="tcpMssAdjust")
    def tcp_mss_adjust(self) -> Optional[pulumi.Input[int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        """
        return pulumi.get(self, "tcp_mss_adjust")

    @tcp_mss_adjust.setter
    def tcp_mss_adjust(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_mss_adjust", value)

    @property
    @pulumi.getter(name="tcpMssAdjustVariable")
    def tcp_mss_adjust_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_adjust_variable")

    @tcp_mss_adjust_variable.setter
    def tcp_mss_adjust_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_mss_adjust_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="trackerVariable")
    def tracker_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_variable")

    @tracker_variable.setter
    def tracker_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracker_variable", value)

    @property
    @pulumi.getter
    def trackers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Enable tracker for this interface
        """
        return pulumi.get(self, "trackers")

    @trackers.setter
    def trackers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trackers", value)

    @property
    @pulumi.getter(name="tunnelDestination")
    def tunnel_destination(self) -> Optional[pulumi.Input[str]]:
        """
        Tunnel destination IP Address
        """
        return pulumi.get(self, "tunnel_destination")

    @tunnel_destination.setter
    def tunnel_destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_destination", value)

    @property
    @pulumi.getter(name="tunnelDestinationVariable")
    def tunnel_destination_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_destination_variable")

    @tunnel_destination_variable.setter
    def tunnel_destination_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_destination_variable", value)

    @property
    @pulumi.getter(name="tunnelRouteVia")
    def tunnel_route_via(self) -> Optional[pulumi.Input[str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_route_via")

    @tunnel_route_via.setter
    def tunnel_route_via(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_route_via", value)

    @property
    @pulumi.getter(name="tunnelRouteViaVariable")
    def tunnel_route_via_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_route_via_variable")

    @tunnel_route_via_variable.setter
    def tunnel_route_via_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_route_via_variable", value)

    @property
    @pulumi.getter(name="tunnelSource")
    def tunnel_source(self) -> Optional[pulumi.Input[str]]:
        """
        Tunnel source IP Address
        """
        return pulumi.get(self, "tunnel_source")

    @tunnel_source.setter
    def tunnel_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_source", value)

    @property
    @pulumi.getter(name="tunnelSourceInterface")
    def tunnel_source_interface(self) -> Optional[pulumi.Input[str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_source_interface")

    @tunnel_source_interface.setter
    def tunnel_source_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_source_interface", value)

    @property
    @pulumi.getter(name="tunnelSourceInterfaceVariable")
    def tunnel_source_interface_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_variable")

    @tunnel_source_interface_variable.setter
    def tunnel_source_interface_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_source_interface_variable", value)

    @property
    @pulumi.getter(name="tunnelSourceVariable")
    def tunnel_source_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_variable")

    @tunnel_source_variable.setter
    def tunnel_source_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_source_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CiscoVpnInterfaceGreFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs', 'CiscoVpnInterfaceGreFeatureTemplateAccessListArgsDict']]]]] = None,
                 application: Optional[pulumi.Input[str]] = None,
                 application_variable: Optional[pulumi.Input[str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 interface_description: Optional[pulumi.Input[str]] = None,
                 interface_description_variable: Optional[pulumi.Input[str]] = None,
                 interface_name: Optional[pulumi.Input[str]] = None,
                 interface_name_variable: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_address_variable: Optional[pulumi.Input[str]] = None,
                 ip_mtu: Optional[pulumi.Input[int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rewrite_rule: Optional[pulumi.Input[str]] = None,
                 rewrite_rule_variable: Optional[pulumi.Input[str]] = None,
                 shutdown: Optional[pulumi.Input[bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[str]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[str]] = None,
                 tracker_variable: Optional[pulumi.Input[str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tunnel_destination: Optional[pulumi.Input[str]] = None,
                 tunnel_destination_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_route_via: Optional[pulumi.Input[str]] = None,
                 tunnel_route_via_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_source: Optional[pulumi.Input[str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_source_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco VPN Interface GRE feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoVpnInterfaceGreFeatureTemplate:CiscoVpnInterfaceGreFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs', 'CiscoVpnInterfaceGreFeatureTemplateAccessListArgsDict']]]] access_lists: Apply ACL
        :param pulumi.Input[str] application: Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        :param pulumi.Input[str] application_variable: Variable name
        :param pulumi.Input[bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] interface_description: Interface description
        :param pulumi.Input[str] interface_description_variable: Variable name
        :param pulumi.Input[str] interface_name: Interface name: ge0/<0-..> or ge0/<0-..>.vlanid or irb<bridgeid:1-63> or loopback<string> or natpool-<1..31> when
               present
        :param pulumi.Input[str] interface_name_variable: Variable name
        :param pulumi.Input[str] ip_address: Assign IPv4 address
        :param pulumi.Input[str] ip_address_variable: Variable name
        :param pulumi.Input[int] ip_mtu: Interface MTU <576..2000>, in bytes - Range: `64`-`18000` - Default value: `1500`
        :param pulumi.Input[str] ip_mtu_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] rewrite_rule: Name of rewrite rule
        :param pulumi.Input[str] rewrite_rule_variable: Variable name
        :param pulumi.Input[bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[str] shutdown_variable: Variable name
        :param pulumi.Input[int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[str] tcp_mss_adjust_variable: Variable name
        :param pulumi.Input[str] tracker_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trackers: Enable tracker for this interface
        :param pulumi.Input[str] tunnel_destination: Tunnel destination IP Address
        :param pulumi.Input[str] tunnel_destination_variable: Variable name
        :param pulumi.Input[str] tunnel_route_via: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[str] tunnel_route_via_variable: Variable name
        :param pulumi.Input[str] tunnel_source: Tunnel source IP Address
        :param pulumi.Input[str] tunnel_source_interface: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[str] tunnel_source_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoVpnInterfaceGreFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco VPN Interface GRE feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoVpnInterfaceGreFeatureTemplate:CiscoVpnInterfaceGreFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoVpnInterfaceGreFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoVpnInterfaceGreFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs', 'CiscoVpnInterfaceGreFeatureTemplateAccessListArgsDict']]]]] = None,
                 application: Optional[pulumi.Input[str]] = None,
                 application_variable: Optional[pulumi.Input[str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 interface_description: Optional[pulumi.Input[str]] = None,
                 interface_description_variable: Optional[pulumi.Input[str]] = None,
                 interface_name: Optional[pulumi.Input[str]] = None,
                 interface_name_variable: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_address_variable: Optional[pulumi.Input[str]] = None,
                 ip_mtu: Optional[pulumi.Input[int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rewrite_rule: Optional[pulumi.Input[str]] = None,
                 rewrite_rule_variable: Optional[pulumi.Input[str]] = None,
                 shutdown: Optional[pulumi.Input[bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[str]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[str]] = None,
                 tracker_variable: Optional[pulumi.Input[str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tunnel_destination: Optional[pulumi.Input[str]] = None,
                 tunnel_destination_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_route_via: Optional[pulumi.Input[str]] = None,
                 tunnel_route_via_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_source: Optional[pulumi.Input[str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[str]] = None,
                 tunnel_source_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoVpnInterfaceGreFeatureTemplateArgs.__new__(CiscoVpnInterfaceGreFeatureTemplateArgs)

            __props__.__dict__["access_lists"] = access_lists
            __props__.__dict__["application"] = application
            __props__.__dict__["application_variable"] = application_variable
            __props__.__dict__["clear_dont_fragment"] = clear_dont_fragment
            __props__.__dict__["clear_dont_fragment_variable"] = clear_dont_fragment_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["interface_description"] = interface_description
            __props__.__dict__["interface_description_variable"] = interface_description_variable
            __props__.__dict__["interface_name"] = interface_name
            __props__.__dict__["interface_name_variable"] = interface_name_variable
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["ip_address_variable"] = ip_address_variable
            __props__.__dict__["ip_mtu"] = ip_mtu
            __props__.__dict__["ip_mtu_variable"] = ip_mtu_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["rewrite_rule"] = rewrite_rule
            __props__.__dict__["rewrite_rule_variable"] = rewrite_rule_variable
            __props__.__dict__["shutdown"] = shutdown
            __props__.__dict__["shutdown_variable"] = shutdown_variable
            __props__.__dict__["tcp_mss_adjust"] = tcp_mss_adjust
            __props__.__dict__["tcp_mss_adjust_variable"] = tcp_mss_adjust_variable
            __props__.__dict__["tracker_variable"] = tracker_variable
            __props__.__dict__["trackers"] = trackers
            __props__.__dict__["tunnel_destination"] = tunnel_destination
            __props__.__dict__["tunnel_destination_variable"] = tunnel_destination_variable
            __props__.__dict__["tunnel_route_via"] = tunnel_route_via
            __props__.__dict__["tunnel_route_via_variable"] = tunnel_route_via_variable
            __props__.__dict__["tunnel_source"] = tunnel_source
            __props__.__dict__["tunnel_source_interface"] = tunnel_source_interface
            __props__.__dict__["tunnel_source_interface_variable"] = tunnel_source_interface_variable
            __props__.__dict__["tunnel_source_variable"] = tunnel_source_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoVpnInterfaceGreFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoVpnInterfaceGreFeatureTemplate:CiscoVpnInterfaceGreFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs', 'CiscoVpnInterfaceGreFeatureTemplateAccessListArgsDict']]]]] = None,
            application: Optional[pulumi.Input[str]] = None,
            application_variable: Optional[pulumi.Input[str]] = None,
            clear_dont_fragment: Optional[pulumi.Input[bool]] = None,
            clear_dont_fragment_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            interface_description: Optional[pulumi.Input[str]] = None,
            interface_description_variable: Optional[pulumi.Input[str]] = None,
            interface_name: Optional[pulumi.Input[str]] = None,
            interface_name_variable: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            ip_address_variable: Optional[pulumi.Input[str]] = None,
            ip_mtu: Optional[pulumi.Input[int]] = None,
            ip_mtu_variable: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rewrite_rule: Optional[pulumi.Input[str]] = None,
            rewrite_rule_variable: Optional[pulumi.Input[str]] = None,
            shutdown: Optional[pulumi.Input[bool]] = None,
            shutdown_variable: Optional[pulumi.Input[str]] = None,
            tcp_mss_adjust: Optional[pulumi.Input[int]] = None,
            tcp_mss_adjust_variable: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            tracker_variable: Optional[pulumi.Input[str]] = None,
            trackers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tunnel_destination: Optional[pulumi.Input[str]] = None,
            tunnel_destination_variable: Optional[pulumi.Input[str]] = None,
            tunnel_route_via: Optional[pulumi.Input[str]] = None,
            tunnel_route_via_variable: Optional[pulumi.Input[str]] = None,
            tunnel_source: Optional[pulumi.Input[str]] = None,
            tunnel_source_interface: Optional[pulumi.Input[str]] = None,
            tunnel_source_interface_variable: Optional[pulumi.Input[str]] = None,
            tunnel_source_variable: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CiscoVpnInterfaceGreFeatureTemplate':
        """
        Get an existing CiscoVpnInterfaceGreFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnInterfaceGreFeatureTemplateAccessListArgs', 'CiscoVpnInterfaceGreFeatureTemplateAccessListArgsDict']]]] access_lists: Apply ACL
        :param pulumi.Input[str] application: Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        :param pulumi.Input[str] application_variable: Variable name
        :param pulumi.Input[bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] interface_description: Interface description
        :param pulumi.Input[str] interface_description_variable: Variable name
        :param pulumi.Input[str] interface_name: Interface name: ge0/<0-..> or ge0/<0-..>.vlanid or irb<bridgeid:1-63> or loopback<string> or natpool-<1..31> when
               present
        :param pulumi.Input[str] interface_name_variable: Variable name
        :param pulumi.Input[str] ip_address: Assign IPv4 address
        :param pulumi.Input[str] ip_address_variable: Variable name
        :param pulumi.Input[int] ip_mtu: Interface MTU <576..2000>, in bytes - Range: `64`-`18000` - Default value: `1500`
        :param pulumi.Input[str] ip_mtu_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] rewrite_rule: Name of rewrite rule
        :param pulumi.Input[str] rewrite_rule_variable: Variable name
        :param pulumi.Input[bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[str] shutdown_variable: Variable name
        :param pulumi.Input[int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[str] tcp_mss_adjust_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[str] tracker_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trackers: Enable tracker for this interface
        :param pulumi.Input[str] tunnel_destination: Tunnel destination IP Address
        :param pulumi.Input[str] tunnel_destination_variable: Variable name
        :param pulumi.Input[str] tunnel_route_via: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[str] tunnel_route_via_variable: Variable name
        :param pulumi.Input[str] tunnel_source: Tunnel source IP Address
        :param pulumi.Input[str] tunnel_source_interface: <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        :param pulumi.Input[str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[str] tunnel_source_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoVpnInterfaceGreFeatureTemplateState.__new__(_CiscoVpnInterfaceGreFeatureTemplateState)

        __props__.__dict__["access_lists"] = access_lists
        __props__.__dict__["application"] = application
        __props__.__dict__["application_variable"] = application_variable
        __props__.__dict__["clear_dont_fragment"] = clear_dont_fragment
        __props__.__dict__["clear_dont_fragment_variable"] = clear_dont_fragment_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["interface_description"] = interface_description
        __props__.__dict__["interface_description_variable"] = interface_description_variable
        __props__.__dict__["interface_name"] = interface_name
        __props__.__dict__["interface_name_variable"] = interface_name_variable
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_address_variable"] = ip_address_variable
        __props__.__dict__["ip_mtu"] = ip_mtu
        __props__.__dict__["ip_mtu_variable"] = ip_mtu_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["rewrite_rule"] = rewrite_rule
        __props__.__dict__["rewrite_rule_variable"] = rewrite_rule_variable
        __props__.__dict__["shutdown"] = shutdown
        __props__.__dict__["shutdown_variable"] = shutdown_variable
        __props__.__dict__["tcp_mss_adjust"] = tcp_mss_adjust
        __props__.__dict__["tcp_mss_adjust_variable"] = tcp_mss_adjust_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["tracker_variable"] = tracker_variable
        __props__.__dict__["trackers"] = trackers
        __props__.__dict__["tunnel_destination"] = tunnel_destination
        __props__.__dict__["tunnel_destination_variable"] = tunnel_destination_variable
        __props__.__dict__["tunnel_route_via"] = tunnel_route_via
        __props__.__dict__["tunnel_route_via_variable"] = tunnel_route_via_variable
        __props__.__dict__["tunnel_source"] = tunnel_source
        __props__.__dict__["tunnel_source_interface"] = tunnel_source_interface
        __props__.__dict__["tunnel_source_interface_variable"] = tunnel_source_interface_variable
        __props__.__dict__["tunnel_source_variable"] = tunnel_source_variable
        __props__.__dict__["version"] = version
        return CiscoVpnInterfaceGreFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLists")
    def access_lists(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnInterfaceGreFeatureTemplateAccessList']]]:
        """
        Apply ACL
        """
        return pulumi.get(self, "access_lists")

    @property
    @pulumi.getter
    def application(self) -> pulumi.Output[Optional[str]]:
        """
        Enable Application Tunnel Type - Choices: `none`, `sig` - Default value: `none`
        """
        return pulumi.get(self, "application")

    @property
    @pulumi.getter(name="applicationVariable")
    def application_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "application_variable")

    @property
    @pulumi.getter(name="clearDontFragment")
    def clear_dont_fragment(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        """
        return pulumi.get(self, "clear_dont_fragment")

    @property
    @pulumi.getter(name="clearDontFragmentVariable")
    def clear_dont_fragment_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "clear_dont_fragment_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> pulumi.Output[Optional[str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> pulumi.Output[Optional[str]]:
        """
        Interface name: ge0/<0-..> or ge0/<0-..>.vlanid or irb<bridgeid:1-63> or loopback<string> or natpool-<1..31> when
        present
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[Optional[str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipAddressVariable")
    def ip_address_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_address_variable")

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> pulumi.Output[Optional[int]]:
        """
        Interface MTU <576..2000>, in bytes - Range: `64`-`18000` - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rewriteRule")
    def rewrite_rule(self) -> pulumi.Output[Optional[str]]:
        """
        Name of rewrite rule
        """
        return pulumi.get(self, "rewrite_rule")

    @property
    @pulumi.getter(name="rewriteRuleVariable")
    def rewrite_rule_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rewrite_rule_variable")

    @property
    @pulumi.getter
    def shutdown(self) -> pulumi.Output[Optional[bool]]:
        """
        Administrative state - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @property
    @pulumi.getter(name="tcpMssAdjust")
    def tcp_mss_adjust(self) -> pulumi.Output[Optional[int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        """
        return pulumi.get(self, "tcp_mss_adjust")

    @property
    @pulumi.getter(name="tcpMssAdjustVariable")
    def tcp_mss_adjust_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_adjust_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="trackerVariable")
    def tracker_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tracker_variable")

    @property
    @pulumi.getter
    def trackers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Enable tracker for this interface
        """
        return pulumi.get(self, "trackers")

    @property
    @pulumi.getter(name="tunnelDestination")
    def tunnel_destination(self) -> pulumi.Output[Optional[str]]:
        """
        Tunnel destination IP Address
        """
        return pulumi.get(self, "tunnel_destination")

    @property
    @pulumi.getter(name="tunnelDestinationVariable")
    def tunnel_destination_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_destination_variable")

    @property
    @pulumi.getter(name="tunnelRouteVia")
    def tunnel_route_via(self) -> pulumi.Output[Optional[str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_route_via")

    @property
    @pulumi.getter(name="tunnelRouteViaVariable")
    def tunnel_route_via_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_route_via_variable")

    @property
    @pulumi.getter(name="tunnelSource")
    def tunnel_source(self) -> pulumi.Output[Optional[str]]:
        """
        Tunnel source IP Address
        """
        return pulumi.get(self, "tunnel_source")

    @property
    @pulumi.getter(name="tunnelSourceInterface")
    def tunnel_source_interface(self) -> pulumi.Output[Optional[str]]:
        """
        <1..32 characters> Interface name: ge0/<0-..> or ge0/<0-..>.vlanid
        """
        return pulumi.get(self, "tunnel_source_interface")

    @property
    @pulumi.getter(name="tunnelSourceInterfaceVariable")
    def tunnel_source_interface_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_variable")

    @property
    @pulumi.getter(name="tunnelSourceVariable")
    def tunnel_source_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

