# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CliTemplateFeatureTemplateArgs', 'CliTemplateFeatureTemplate']

@pulumi.input_type
class CliTemplateFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 cli_config: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CliTemplateFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] cli_config: Cli config
        :param pulumi.Input[str] name: The name of the feature template
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if cli_config is not None:
            pulumi.set(__self__, "cli_config", cli_config)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="cliConfig")
    def cli_config(self) -> Optional[pulumi.Input[str]]:
        """
        Cli config
        """
        return pulumi.get(self, "cli_config")

    @cli_config.setter
    def cli_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cli_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CliTemplateFeatureTemplateState:
    def __init__(__self__, *,
                 cli_config: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CliTemplateFeatureTemplate resources.
        :param pulumi.Input[str] cli_config: Cli config
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        if cli_config is not None:
            pulumi.set(__self__, "cli_config", cli_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cliConfig")
    def cli_config(self) -> Optional[pulumi.Input[str]]:
        """
        Cli config
        """
        return pulumi.get(self, "cli_config")

    @cli_config.setter
    def cli_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cli_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CliTemplateFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cli_config: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a CLI Template feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CliTemplateFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            cli_config=\"\"\"! Enable new BGP community format
        ip bgp-community new-format
        \"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/cliTemplateFeatureTemplate:CliTemplateFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cli_config: Cli config
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] name: The name of the feature template
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CliTemplateFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a CLI Template feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CliTemplateFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            cli_config=\"\"\"! Enable new BGP community format
        ip bgp-community new-format
        \"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/cliTemplateFeatureTemplate:CliTemplateFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CliTemplateFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CliTemplateFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cli_config: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CliTemplateFeatureTemplateArgs.__new__(CliTemplateFeatureTemplateArgs)

            __props__.__dict__["cli_config"] = cli_config
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["name"] = name
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CliTemplateFeatureTemplate, __self__).__init__(
            'sdwan:index/cliTemplateFeatureTemplate:CliTemplateFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cli_config: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CliTemplateFeatureTemplate':
        """
        Get an existing CliTemplateFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cli_config: Cli config
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CliTemplateFeatureTemplateState.__new__(_CliTemplateFeatureTemplateState)

        __props__.__dict__["cli_config"] = cli_config
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["name"] = name
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return CliTemplateFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cliConfig")
    def cli_config(self) -> pulumi.Output[Optional[str]]:
        """
        Cli config
        """
        return pulumi.get(self, "cli_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

