# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceRoutePolicyFeatureArgs', 'ServiceRoutePolicyFeature']

@pulumi.input_type
class ServiceRoutePolicyFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[str],
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sequences: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutePolicyFeatureSequenceArgs']]]] = None):
        """
        The set of arguments for constructing a ServiceRoutePolicyFeature resource.
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] default_action: Default Action - Choices: `reject`, `accept` - Default value: `reject`
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRoutePolicyFeatureSequenceArgs']]] sequences: Route Policy List
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sequences is not None:
            pulumi.set(__self__, "sequences", sequences)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[str]]:
        """
        Default Action - Choices: `reject`, `accept` - Default value: `reject`
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sequences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutePolicyFeatureSequenceArgs']]]]:
        """
        Route Policy List
        """
        return pulumi.get(self, "sequences")

    @sequences.setter
    def sequences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutePolicyFeatureSequenceArgs']]]]):
        pulumi.set(self, "sequences", value)


@pulumi.input_type
class _ServiceRoutePolicyFeatureState:
    def __init__(__self__, *,
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sequences: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutePolicyFeatureSequenceArgs']]]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ServiceRoutePolicyFeature resources.
        :param pulumi.Input[str] default_action: Default Action - Choices: `reject`, `accept` - Default value: `reject`
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRoutePolicyFeatureSequenceArgs']]] sequences: Route Policy List
        :param pulumi.Input[int] version: The version of the Feature
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sequences is not None:
            pulumi.set(__self__, "sequences", sequences)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[str]]:
        """
        Default Action - Choices: `reject`, `accept` - Default value: `reject`
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sequences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutePolicyFeatureSequenceArgs']]]]:
        """
        Route Policy List
        """
        return pulumi.get(self, "sequences")

    @sequences.setter
    def sequences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRoutePolicyFeatureSequenceArgs']]]]):
        pulumi.set(self, "sequences", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class ServiceRoutePolicyFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sequences: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutePolicyFeatureSequenceArgs', 'ServiceRoutePolicyFeatureSequenceArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a Service Route Policy Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/serviceRoutePolicyFeature:ServiceRoutePolicyFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_action: Default Action - Choices: `reject`, `accept` - Default value: `reject`
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutePolicyFeatureSequenceArgs', 'ServiceRoutePolicyFeatureSequenceArgsDict']]]] sequences: Route Policy List
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceRoutePolicyFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service Route Policy Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/serviceRoutePolicyFeature:ServiceRoutePolicyFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceRoutePolicyFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceRoutePolicyFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sequences: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutePolicyFeatureSequenceArgs', 'ServiceRoutePolicyFeatureSequenceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceRoutePolicyFeatureArgs.__new__(ServiceRoutePolicyFeatureArgs)

            __props__.__dict__["default_action"] = default_action
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["sequences"] = sequences
            __props__.__dict__["version"] = None
        super(ServiceRoutePolicyFeature, __self__).__init__(
            'sdwan:index/serviceRoutePolicyFeature:ServiceRoutePolicyFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_action: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            feature_profile_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            sequences: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutePolicyFeatureSequenceArgs', 'ServiceRoutePolicyFeatureSequenceArgsDict']]]]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'ServiceRoutePolicyFeature':
        """
        Get an existing ServiceRoutePolicyFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_action: Default Action - Choices: `reject`, `accept` - Default value: `reject`
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceRoutePolicyFeatureSequenceArgs', 'ServiceRoutePolicyFeatureSequenceArgsDict']]]] sequences: Route Policy List
        :param pulumi.Input[int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceRoutePolicyFeatureState.__new__(_ServiceRoutePolicyFeatureState)

        __props__.__dict__["default_action"] = default_action
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["sequences"] = sequences
        __props__.__dict__["version"] = version
        return ServiceRoutePolicyFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Output[Optional[str]]:
        """
        Default Action - Choices: `reject`, `accept` - Default value: `reject`
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sequences(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceRoutePolicyFeatureSequence']]]:
        """
        Route Policy List
        """
        return pulumi.get(self, "sequences")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

