# Generated by Django 2.2.4 on 2019-08-26 20:32

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('geography', '0002_point_pointlabeloffset'),
        ('government', '0003_office_senate_class'),
        ('entity', '0004_auto_20190104_1616'),
    ]

    operations = [
        migrations.CreateModel(
            name='Candidate',
            fields=[
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('ap_candidate_id', models.CharField(blank=True, max_length=255, null=True)),
                ('incumbent', models.BooleanField(default=False)),
                ('prospective', models.BooleanField(default=False, help_text='The candidate has not yet declared her candidacy.')),
                ('party', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidates', to='government.Party')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidacies', to='entity.Person')),
            ],
        ),
        migrations.CreateModel(
            name='CandidateElection',
            fields=[
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('aggregable', models.BooleanField(default=True)),
                ('uncontested', models.BooleanField(default=False)),
                ('candidate', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='candidate_elections', to='election.Candidate')),
            ],
        ),
        migrations.CreateModel(
            name='ElectionCycle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('name', models.CharField(max_length=4)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ElectionDay',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('date', models.DateField(unique=True)),
                ('cycle', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='elections_days', to='election.ElectionCycle')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ElectionType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('slug', models.SlugField(blank=True, choices=[('general', 'General'), ('party-primary', 'Party Primary'), ('jungle-primary', 'Jungle Primary'), ('primary-runoff', 'Primary Runoff'), ('general-runoff', 'General Runoff')], max_length=255, unique=True)),
                ('label', models.CharField(blank=True, max_length=255)),
                ('short_label', models.CharField(blank=True, max_length=50, null=True)),
                ('ap_code', models.CharField(blank=True, max_length=1, null=True)),
                ('number_of_winners', models.PositiveSmallIntegerField(default=1)),
                ('winning_threshold', models.DecimalField(blank=True, decimal_places=3, max_digits=5, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Race',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('label', models.CharField(blank=True, max_length=255)),
                ('short_label', models.CharField(blank=True, max_length=50, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('special', models.BooleanField(default=False)),
                ('cycle', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='races', to='election.ElectionCycle')),
                ('office', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='races', to='government.Office')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Election',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('candidates', models.ManyToManyField(through='election.CandidateElection', to='election.Candidate')),
                ('division', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='elections', to='geography.Division')),
                ('election_day', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='elections', to='election.ElectionDay')),
                ('election_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='elections', to='election.ElectionType')),
                ('party', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='government.Party')),
                ('race', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='elections', to='election.Race')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='candidateelection',
            name='election',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='candidate_elections', to='election.Election'),
        ),
        migrations.AddField(
            model_name='candidate',
            name='race',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidates', to='election.Race'),
        ),
        migrations.AddField(
            model_name='candidate',
            name='top_of_ticket',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='ticket', to='election.Candidate'),
        ),
        migrations.CreateModel(
            name='BallotMeasure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('label', models.CharField(blank=True, max_length=255)),
                ('short_label', models.CharField(blank=True, max_length=50, null=True)),
                ('question', models.TextField()),
                ('number', models.CharField(max_length=3)),
                ('division', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='ballot_measures', to='geography.Division')),
                ('election_day', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='ballot_measures', to='election.ElectionDay')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BallotAnswer',
            fields=[
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('label', models.CharField(blank=True, max_length=255)),
                ('short_label', models.CharField(blank=True, max_length=50, null=True)),
                ('answer', models.TextField()),
                ('winner', models.BooleanField(default=False)),
                ('ballot_measure', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='election.BallotMeasure')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ElectionEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('label', models.CharField(max_length=100)),
                ('event_type', models.CharField(choices=[('Primaries', 'Primaries'), ('Primaries Runoff', 'Primaries Runoff'), ('General', 'General'), ('General Runoff', 'General Runoff'), ('Special Primary', 'Special Primary'), ('Special Runoff', 'Special Runoff'), ('Special General', 'Special General')], max_length=50)),
                ('dem_primary_type', models.CharField(blank=True, choices=[('open', 'Open'), ('semi-open', 'Semi-open'), ('semi-closed', 'Semi-closed'), ('closed', 'Closed'), ('jungle', 'Jungle')], max_length=50, null=True)),
                ('gop_primary_type', models.CharField(blank=True, choices=[('open', 'Open'), ('semi-open', 'Semi-open'), ('semi-closed', 'Semi-closed'), ('closed', 'Closed'), ('jungle', 'Jungle')], max_length=50, null=True)),
                ('early_vote_start', models.DateField(blank=True, null=True)),
                ('early_vote_close', models.DateField(blank=True, null=True)),
                ('vote_by_mail_application_deadline', models.DateField(blank=True, null=True)),
                ('vote_by_mail_ballot_deadline', models.DateField(blank=True, null=True)),
                ('online_registration_deadline', models.DateField(blank=True, null=True)),
                ('registration_deadline', models.DateField(blank=True, null=True)),
                ('poll_closing_time', models.DateTimeField(blank=True, null=True)),
                ('division', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='geography.Division')),
                ('election_day', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='election.ElectionDay')),
            ],
            options={
                'unique_together': {('division', 'election_day', 'event_type', 'dem_primary_type', 'gop_primary_type')},
            },
        ),
        migrations.AlterUniqueTogether(
            name='candidateelection',
            unique_together={('candidate', 'election')},
        ),
        migrations.AlterUniqueTogether(
            name='candidate',
            unique_together={('person', 'race', 'party')},
        ),
    ]
