# -*- coding: utf-8 -*-
# Generated by Django 1.9.6 on 2016-12-27 14:57
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


def add_default_creds(apps, schema_editor):
    from django.conf import settings
    APICredentials = apps.get_model("wellsfargo", "APICredentials")
    creds = APICredentials()
    creds.username = getattr(settings, 'WFRS_USER_NAME', '')
    creds.password = getattr(settings, 'WFRS_PASSWORD', '')
    creds.merchant_num = getattr(settings, 'WFRS_MERCHANT_NUM', '')
    creds.user_group = None
    creds.priority = 1
    creds.save()


class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0007_alter_validators_add_error_messages'),
        ('wellsfargo', '0005_auto_20161122_1503'),
    ]

    operations = [
        migrations.CreateModel(
            name='APICredentials',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(max_length=200, verbose_name='WFRS API Username')),
                ('password', models.CharField(max_length=200, verbose_name='WFRS API Password')),
                ('merchant_num', models.CharField(max_length=200, verbose_name='WFRS API Merchant Number')),
                ('priority', models.IntegerField(default=1, verbose_name='Priority Order')),
                ('user_group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.Group')),
            ],
            options={
                'verbose_name': 'API Credentials',
                'verbose_name_plural': 'API Credentials',
                'ordering': ('-priority', '-id'),
            },
        ),
        migrations.RunPython(add_default_creds, lambda apps, schema_editor: 1),
    ]
