# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ModelComponentModelArgs',
    'ModelComponentModelArgsDict',
    'ModelLockArgs',
    'ModelLockArgsDict',
    'ModelMetricArgs',
    'ModelMetricArgsDict',
    'ModelMetricDatasetSummaryArgs',
    'ModelMetricDatasetSummaryArgsDict',
    'ModelMetricLabelMetricsReportArgs',
    'ModelMetricLabelMetricsReportArgsDict',
    'ModelMetricLabelMetricsReportConfidenceEntryArgs',
    'ModelMetricLabelMetricsReportConfidenceEntryArgsDict',
    'ModelMetricOverallMetricsReportArgs',
    'ModelMetricOverallMetricsReportArgsDict',
    'ModelMetricOverallMetricsReportConfidenceEntryArgs',
    'ModelMetricOverallMetricsReportConfidenceEntryArgsDict',
    'ModelModelSubTypeArgs',
    'ModelModelSubTypeArgsDict',
    'ModelTestingDatasetArgs',
    'ModelTestingDatasetArgsDict',
    'ModelTrainingDatasetArgs',
    'ModelTrainingDatasetArgsDict',
    'ModelValidationDatasetArgs',
    'ModelValidationDatasetArgsDict',
    'ProcessorJobInputLocationArgs',
    'ProcessorJobInputLocationArgsDict',
    'ProcessorJobInputLocationObjectLocationArgs',
    'ProcessorJobInputLocationObjectLocationArgsDict',
    'ProcessorJobOutputLocationArgs',
    'ProcessorJobOutputLocationArgsDict',
    'ProcessorJobProcessorConfigArgs',
    'ProcessorJobProcessorConfigArgsDict',
    'ProcessorJobProcessorConfigFeatureArgs',
    'ProcessorJobProcessorConfigFeatureArgsDict',
    'ProcessorJobProcessorConfigNormalizationFieldArgs',
    'ProcessorJobProcessorConfigNormalizationFieldArgsDict',
    'ProcessorJobProcessorConfigNormalizationFieldMapArgs',
    'ProcessorJobProcessorConfigNormalizationFieldMapArgsDict',
    'ProjectLockArgs',
    'ProjectLockArgsDict',
    'GetModelsFilterArgs',
    'GetModelsFilterArgsDict',
    'GetProjectsFilterArgs',
    'GetProjectsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class ModelComponentModelArgsDict(TypedDict):
        model_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
elif False:
    ModelComponentModelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelComponentModelArgs:
    def __init__(__self__, *,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_id", value)


if not MYPY:
    class ModelLockArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Lock type.
        """
        compartment_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The compartment identifier.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        related_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        When the model was created, as an RFC3339 datetime string.
        """
elif False:
    ModelLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelLockArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Lock type.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment identifier.
        :param pulumi.Input[_builtins.str] message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param pulumi.Input[_builtins.str] related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param pulumi.Input[_builtins.str] time_created: When the model was created, as an RFC3339 datetime string.
        """
        pulumi.set(__self__, "type", type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Lock type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class ModelMetricArgsDict(TypedDict):
        dataset_summaries: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgsDict']]]]
        """
        Summary of count of samples used during model training.
        """
        label_metrics_reports: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgsDict']]]]
        """
        List of metrics entries per label.
        """
        model_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of the Document model.
        """
        overall_metrics_reports: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgsDict']]]]
        """
        Overall Metrics report for Document Classification Model.
        """
elif False:
    ModelMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricArgs:
    def __init__(__self__, *,
                 dataset_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]]] = None,
                 label_metrics_reports: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]]] = None,
                 model_type: Optional[pulumi.Input[_builtins.str]] = None,
                 overall_metrics_reports: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]] dataset_summaries: Summary of count of samples used during model training.
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]] label_metrics_reports: List of metrics entries per label.
        :param pulumi.Input[_builtins.str] model_type: The type of the Document model.
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        if dataset_summaries is not None:
            pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        if label_metrics_reports is not None:
            pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if overall_metrics_reports is not None:
            pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @_builtins.property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]]]:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @dataset_summaries.setter
    def dataset_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]]]):
        pulumi.set(self, "dataset_summaries", value)

    @_builtins.property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]]]:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @label_metrics_reports.setter
    def label_metrics_reports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]]]):
        pulumi.set(self, "label_metrics_reports", value)

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_type", value)

    @_builtins.property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]]]:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")

    @overall_metrics_reports.setter
    def overall_metrics_reports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]]]):
        pulumi.set(self, "overall_metrics_reports", value)


if not MYPY:
    class ModelMetricDatasetSummaryArgsDict(TypedDict):
        test_sample_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of samples used for testing the model.
        """
        training_sample_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of samples used for training the model.
        """
        validation_sample_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of samples used for validating the model.
        """
elif False:
    ModelMetricDatasetSummaryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricDatasetSummaryArgs:
    def __init__(__self__, *,
                 test_sample_count: Optional[pulumi.Input[_builtins.int]] = None,
                 training_sample_count: Optional[pulumi.Input[_builtins.int]] = None,
                 validation_sample_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] test_sample_count: Number of samples used for testing the model.
        :param pulumi.Input[_builtins.int] training_sample_count: Number of samples used for training the model.
        :param pulumi.Input[_builtins.int] validation_sample_count: Number of samples used for validating the model.
        """
        if test_sample_count is not None:
            pulumi.set(__self__, "test_sample_count", test_sample_count)
        if training_sample_count is not None:
            pulumi.set(__self__, "training_sample_count", training_sample_count)
        if validation_sample_count is not None:
            pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @_builtins.property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @test_sample_count.setter
    def test_sample_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "test_sample_count", value)

    @_builtins.property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @training_sample_count.setter
    def training_sample_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "training_sample_count", value)

    @_builtins.property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")

    @validation_sample_count.setter
    def validation_sample_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "validation_sample_count", value)


if not MYPY:
    class ModelMetricLabelMetricsReportArgsDict(TypedDict):
        confidence_entries: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgsDict']]]]
        """
        List of document classification confidence report.
        """
        document_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Total test documents in the label.
        """
        label: NotRequired[pulumi.Input[_builtins.str]]
        """
        Label name
        """
        mean_average_precision: NotRequired[pulumi.Input[_builtins.float]]
        """
        Mean average precision under different thresholds
        """
elif False:
    ModelMetricLabelMetricsReportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricLabelMetricsReportArgs:
    def __init__(__self__, *,
                 confidence_entries: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]]] = None,
                 document_count: Optional[pulumi.Input[_builtins.int]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 mean_average_precision: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]] confidence_entries: List of document classification confidence report.
        :param pulumi.Input[_builtins.int] document_count: Total test documents in the label.
        :param pulumi.Input[_builtins.str] label: Label name
        :param pulumi.Input[_builtins.float] mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @_builtins.property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]]]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @confidence_entries.setter
    def confidence_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]]]):
        pulumi.set(self, "confidence_entries", value)

    @_builtins.property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @document_count.setter
    def document_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "document_count", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")

    @mean_average_precision.setter
    def mean_average_precision(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "mean_average_precision", value)


if not MYPY:
    class ModelMetricLabelMetricsReportConfidenceEntryArgsDict(TypedDict):
        accuracy: NotRequired[pulumi.Input[_builtins.float]]
        """
        accuracy under the threshold
        """
        f1score: NotRequired[pulumi.Input[_builtins.float]]
        """
        f1Score under the threshold
        """
        precision: NotRequired[pulumi.Input[_builtins.float]]
        """
        Precision under the threshold
        """
        recall: NotRequired[pulumi.Input[_builtins.float]]
        """
        Recall under the threshold
        """
        threshold: NotRequired[pulumi.Input[_builtins.float]]
        """
        Threshold used to calculate precision and recall.
        """
elif False:
    ModelMetricLabelMetricsReportConfidenceEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricLabelMetricsReportConfidenceEntryArgs:
    def __init__(__self__, *,
                 accuracy: Optional[pulumi.Input[_builtins.float]] = None,
                 f1score: Optional[pulumi.Input[_builtins.float]] = None,
                 precision: Optional[pulumi.Input[_builtins.float]] = None,
                 recall: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.float] accuracy: accuracy under the threshold
        :param pulumi.Input[_builtins.float] f1score: f1Score under the threshold
        :param pulumi.Input[_builtins.float] precision: Precision under the threshold
        :param pulumi.Input[_builtins.float] recall: Recall under the threshold
        :param pulumi.Input[_builtins.float] threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def accuracy(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @accuracy.setter
    def accuracy(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "accuracy", value)

    @_builtins.property
    @pulumi.getter
    def f1score(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @f1score.setter
    def f1score(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "f1score", value)

    @_builtins.property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "precision", value)

    @_builtins.property
    @pulumi.getter
    def recall(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @recall.setter
    def recall(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "recall", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "threshold", value)


if not MYPY:
    class ModelMetricOverallMetricsReportArgsDict(TypedDict):
        confidence_entries: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgsDict']]]]
        """
        List of document classification confidence report.
        """
        document_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Total test documents in the label.
        """
        mean_average_precision: NotRequired[pulumi.Input[_builtins.float]]
        """
        Mean average precision under different thresholds
        """
elif False:
    ModelMetricOverallMetricsReportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricOverallMetricsReportArgs:
    def __init__(__self__, *,
                 confidence_entries: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]]] = None,
                 document_count: Optional[pulumi.Input[_builtins.int]] = None,
                 mean_average_precision: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]] confidence_entries: List of document classification confidence report.
        :param pulumi.Input[_builtins.int] document_count: Total test documents in the label.
        :param pulumi.Input[_builtins.float] mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @_builtins.property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]]]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @confidence_entries.setter
    def confidence_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]]]):
        pulumi.set(self, "confidence_entries", value)

    @_builtins.property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @document_count.setter
    def document_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "document_count", value)

    @_builtins.property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")

    @mean_average_precision.setter
    def mean_average_precision(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "mean_average_precision", value)


if not MYPY:
    class ModelMetricOverallMetricsReportConfidenceEntryArgsDict(TypedDict):
        accuracy: NotRequired[pulumi.Input[_builtins.float]]
        """
        accuracy under the threshold
        """
        f1score: NotRequired[pulumi.Input[_builtins.float]]
        """
        f1Score under the threshold
        """
        precision: NotRequired[pulumi.Input[_builtins.float]]
        """
        Precision under the threshold
        """
        recall: NotRequired[pulumi.Input[_builtins.float]]
        """
        Recall under the threshold
        """
        threshold: NotRequired[pulumi.Input[_builtins.float]]
        """
        Threshold used to calculate precision and recall.
        """
elif False:
    ModelMetricOverallMetricsReportConfidenceEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricOverallMetricsReportConfidenceEntryArgs:
    def __init__(__self__, *,
                 accuracy: Optional[pulumi.Input[_builtins.float]] = None,
                 f1score: Optional[pulumi.Input[_builtins.float]] = None,
                 precision: Optional[pulumi.Input[_builtins.float]] = None,
                 recall: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.float] accuracy: accuracy under the threshold
        :param pulumi.Input[_builtins.float] f1score: f1Score under the threshold
        :param pulumi.Input[_builtins.float] precision: Precision under the threshold
        :param pulumi.Input[_builtins.float] recall: Recall under the threshold
        :param pulumi.Input[_builtins.float] threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def accuracy(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @accuracy.setter
    def accuracy(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "accuracy", value)

    @_builtins.property
    @pulumi.getter
    def f1score(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @f1score.setter
    def f1score(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "f1score", value)

    @_builtins.property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "precision", value)

    @_builtins.property
    @pulumi.getter
    def recall(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @recall.setter
    def recall(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "recall", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "threshold", value)


if not MYPY:
    class ModelModelSubTypeArgsDict(TypedDict):
        model_sub_type: pulumi.Input[_builtins.str]
        """
        The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
        * `RECEIPT`
        * `INVOICE`
        * `PASSPORT`
        * `DRIVER_LICENSE`
        * `HEALTH_INSURANCE_ID`
        """
        model_type: pulumi.Input[_builtins.str]
        """
        Sub type model based on the model type. The allowed values are:
        * `PRE_TRAINED_KEY_VALUE_EXTRACTION`
        * `PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION`
        """
elif False:
    ModelModelSubTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelModelSubTypeArgs:
    def __init__(__self__, *,
                 model_sub_type: pulumi.Input[_builtins.str],
                 model_type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] model_sub_type: The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
               * `RECEIPT`
               * `INVOICE`
               * `PASSPORT`
               * `DRIVER_LICENSE`
               * `HEALTH_INSURANCE_ID`
        :param pulumi.Input[_builtins.str] model_type: Sub type model based on the model type. The allowed values are:
               * `PRE_TRAINED_KEY_VALUE_EXTRACTION`
               * `PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION`
        """
        pulumi.set(__self__, "model_sub_type", model_sub_type)
        pulumi.set(__self__, "model_type", model_type)

    @_builtins.property
    @pulumi.getter(name="modelSubType")
    def model_sub_type(self) -> pulumi.Input[_builtins.str]:
        """
        The model sub type for PRE_TRAINED_KEY_VALUE_EXTRACTION The allowed values are:
        * `RECEIPT`
        * `INVOICE`
        * `PASSPORT`
        * `DRIVER_LICENSE`
        * `HEALTH_INSURANCE_ID`
        """
        return pulumi.get(self, "model_sub_type")

    @model_sub_type.setter
    def model_sub_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "model_sub_type", value)

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Input[_builtins.str]:
        """
        Sub type model based on the model type. The allowed values are:
        * `PRE_TRAINED_KEY_VALUE_EXTRACTION`
        * `PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION`
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "model_type", value)


if not MYPY:
    class ModelTestingDatasetArgsDict(TypedDict):
        dataset_type: pulumi.Input[_builtins.str]
        """
        The dataset type, based on where it is stored.
        """
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        dataset_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the Data Labeling dataset.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        object: NotRequired[pulumi.Input[_builtins.str]]
        """
        The object name of the input data file.
        """
elif False:
    ModelTestingDatasetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelTestingDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[_builtins.str],
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] dataset_type: The dataset type, based on where it is stored.
        :param pulumi.Input[_builtins.str] bucket: The name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[_builtins.str] dataset_id: OCID of the Data Labeling dataset.
        :param pulumi.Input[_builtins.str] namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[_builtins.str] object: The object name of the input data file.
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[_builtins.str]:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset_type", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)


if not MYPY:
    class ModelTrainingDatasetArgsDict(TypedDict):
        dataset_type: pulumi.Input[_builtins.str]
        """
        The dataset type, based on where it is stored.
        """
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        dataset_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the Data Labeling dataset.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        object: NotRequired[pulumi.Input[_builtins.str]]
        """
        The object name of the input data file.
        """
elif False:
    ModelTrainingDatasetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelTrainingDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[_builtins.str],
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] dataset_type: The dataset type, based on where it is stored.
        :param pulumi.Input[_builtins.str] bucket: The name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[_builtins.str] dataset_id: OCID of the Data Labeling dataset.
        :param pulumi.Input[_builtins.str] namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[_builtins.str] object: The object name of the input data file.
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[_builtins.str]:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset_type", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)


if not MYPY:
    class ModelValidationDatasetArgsDict(TypedDict):
        dataset_type: pulumi.Input[_builtins.str]
        """
        The dataset type, based on where it is stored.
        """
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        dataset_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the Data Labeling dataset.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        object: NotRequired[pulumi.Input[_builtins.str]]
        """
        The object name of the input data file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    ModelValidationDatasetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelValidationDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[_builtins.str],
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] dataset_type: The dataset type, based on where it is stored.
        :param pulumi.Input[_builtins.str] bucket: The name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[_builtins.str] dataset_id: OCID of the Data Labeling dataset.
        :param pulumi.Input[_builtins.str] namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[_builtins.str] object: The object name of the input data file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[_builtins.str]:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset_type", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object name of the input data file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)


if not MYPY:
    class ProcessorJobInputLocationArgsDict(TypedDict):
        source_type: pulumi.Input[_builtins.str]
        """
        The type of input location. The allowed values are:
        * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
        * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        data: NotRequired[pulumi.Input[_builtins.str]]
        """
        Raw document data with Base64 encoding.
        """
        object_locations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgsDict']]]]
        """
        The list of ObjectLocations.
        """
        page_ranges: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The page ranges to be analysed.
        """
elif False:
    ProcessorJobInputLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobInputLocationArgs:
    def __init__(__self__, *,
                 source_type: pulumi.Input[_builtins.str],
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 object_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]]] = None,
                 page_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] source_type: The type of input location. The allowed values are:
               * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
               * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        :param pulumi.Input[_builtins.str] data: Raw document data with Base64 encoding.
        :param pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]] object_locations: The list of ObjectLocations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] page_ranges: The page ranges to be analysed.
        """
        pulumi.set(__self__, "source_type", source_type)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if object_locations is not None:
            pulumi.set(__self__, "object_locations", object_locations)
        if page_ranges is not None:
            pulumi.set(__self__, "page_ranges", page_ranges)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of input location. The allowed values are:
        * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
        * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Raw document data with Base64 encoding.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]]]:
        """
        The list of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @object_locations.setter
    def object_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]]]):
        pulumi.set(self, "object_locations", value)

    @_builtins.property
    @pulumi.getter(name="pageRanges")
    def page_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The page ranges to be analysed.
        """
        return pulumi.get(self, "page_ranges")

    @page_ranges.setter
    def page_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "page_ranges", value)


if not MYPY:
    class ProcessorJobInputLocationObjectLocationArgsDict(TypedDict):
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Object Storage bucket name.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Object Storage namespace name.
        """
        object: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Object Storage object name.
        """
        page_ranges: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The page ranges to be analysed.
        """
elif False:
    ProcessorJobInputLocationObjectLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobInputLocationObjectLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None,
                 page_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] bucket: The Object Storage bucket name.
        :param pulumi.Input[_builtins.str] namespace: The Object Storage namespace name.
        :param pulumi.Input[_builtins.str] object: The Object Storage object name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] page_ranges: The page ranges to be analysed.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if page_ranges is not None:
            pulumi.set(__self__, "page_ranges", page_ranges)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Object Storage namespace name.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Object Storage object name.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)

    @_builtins.property
    @pulumi.getter(name="pageRanges")
    def page_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The page ranges to be analysed.
        """
        return pulumi.get(self, "page_ranges")

    @page_ranges.setter
    def page_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "page_ranges", value)


if not MYPY:
    class ProcessorJobOutputLocationArgsDict(TypedDict):
        bucket: pulumi.Input[_builtins.str]
        """
        The Object Storage bucket name.
        """
        namespace: pulumi.Input[_builtins.str]
        """
        The Object Storage namespace.
        """
        prefix: pulumi.Input[_builtins.str]
        """
        The Object Storage folder name.
        """
elif False:
    ProcessorJobOutputLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobOutputLocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 prefix: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] bucket: The Object Storage bucket name.
        :param pulumi.Input[_builtins.str] namespace: The Object Storage namespace.
        :param pulumi.Input[_builtins.str] prefix: The Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The Object Storage folder name.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "prefix", value)


if not MYPY:
    class ProcessorJobProcessorConfigArgsDict(TypedDict):
        features: pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgsDict']]]
        """
        The types of document analysis requested.
        """
        processor_type: pulumi.Input[_builtins.str]
        """
        The type of the processor.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        document_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The document type.
        """
        is_zip_output_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to generate a ZIP file containing the results.
        """
        language: NotRequired[pulumi.Input[_builtins.str]]
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        model_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Unique identifier custom model OCID that should be used for inference.
        """
        normalization_fields: NotRequired[pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigNormalizationFieldArgsDict']]]]
        """
        A string-to-object map where the key is the normalization field and the object contains information about the field.
        """
elif False:
    ProcessorJobProcessorConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobProcessorConfigArgs:
    def __init__(__self__, *,
                 features: pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]],
                 processor_type: pulumi.Input[_builtins.str],
                 document_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_zip_output_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 normalization_fields: Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigNormalizationFieldArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]] features: The types of document analysis requested.
        :param pulumi.Input[_builtins.str] processor_type: The type of the processor.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] document_type: The document type.
        :param pulumi.Input[_builtins.bool] is_zip_output_enabled: Whether or not to generate a ZIP file containing the results.
        :param pulumi.Input[_builtins.str] language: The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        :param pulumi.Input[_builtins.str] model_id: Unique identifier custom model OCID that should be used for inference.
        :param pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigNormalizationFieldArgs']]] normalization_fields: A string-to-object map where the key is the normalization field and the object contains information about the field.
        """
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "processor_type", processor_type)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if is_zip_output_enabled is not None:
            pulumi.set(__self__, "is_zip_output_enabled", is_zip_output_enabled)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if normalization_fields is not None:
            pulumi.set(__self__, "normalization_fields", normalization_fields)

    @_builtins.property
    @pulumi.getter
    def features(self) -> pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]]:
        """
        The types of document analysis requested.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]]):
        pulumi.set(self, "features", value)

    @_builtins.property
    @pulumi.getter(name="processorType")
    def processor_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the processor.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "processor_type")

    @processor_type.setter
    def processor_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "processor_type", value)

    @_builtins.property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The document type.
        """
        return pulumi.get(self, "document_type")

    @document_type.setter
    def document_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "document_type", value)

    @_builtins.property
    @pulumi.getter(name="isZipOutputEnabled")
    def is_zip_output_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to generate a ZIP file containing the results.
        """
        return pulumi.get(self, "is_zip_output_enabled")

    @is_zip_output_enabled.setter
    def is_zip_output_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_zip_output_enabled", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier custom model OCID that should be used for inference.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_id", value)

    @_builtins.property
    @pulumi.getter(name="normalizationFields")
    def normalization_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigNormalizationFieldArgs']]]]:
        """
        A string-to-object map where the key is the normalization field and the object contains information about the field.
        """
        return pulumi.get(self, "normalization_fields")

    @normalization_fields.setter
    def normalization_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigNormalizationFieldArgs']]]]):
        pulumi.set(self, "normalization_fields", value)


if not MYPY:
    class ProcessorJobProcessorConfigFeatureArgsDict(TypedDict):
        feature_type: pulumi.Input[_builtins.str]
        """
        The type of document analysis requested. The allowed values are:
        * `LANGUAGE_CLASSIFICATION`: Detect the language.
        * `TEXT_EXTRACTION`: Recognize text.
        * `TABLE_EXTRACTION`: Detect and extract data in tables.
        * `KEY_VALUE_EXTRACTION`: Extract form fields.
        * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        * `DOCUMENT_ELEMENTS_EXTRACTION`: Extract information from bar code
        """
        generate_searchable_pdf: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to generate a searchable PDF file.
        """
        max_results: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum number of results to return.
        """
        model_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Unique identifier custom model OCID that should be used for inference.
        """
        selection_mark_detection: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether checkbox detection feature is enabled or disabled.
        """
        tenancy_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
elif False:
    ProcessorJobProcessorConfigFeatureArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobProcessorConfigFeatureArgs:
    def __init__(__self__, *,
                 feature_type: pulumi.Input[_builtins.str],
                 generate_searchable_pdf: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_results: Optional[pulumi.Input[_builtins.int]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 selection_mark_detection: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenancy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] feature_type: The type of document analysis requested. The allowed values are:
               * `LANGUAGE_CLASSIFICATION`: Detect the language.
               * `TEXT_EXTRACTION`: Recognize text.
               * `TABLE_EXTRACTION`: Detect and extract data in tables.
               * `KEY_VALUE_EXTRACTION`: Extract form fields.
               * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
               * `DOCUMENT_ELEMENTS_EXTRACTION`: Extract information from bar code
        :param pulumi.Input[_builtins.bool] generate_searchable_pdf: Whether or not to generate a searchable PDF file.
        :param pulumi.Input[_builtins.int] max_results: The maximum number of results to return.
        :param pulumi.Input[_builtins.str] model_id: Unique identifier custom model OCID that should be used for inference.
        :param pulumi.Input[_builtins.bool] selection_mark_detection: Whether checkbox detection feature is enabled or disabled.
        :param pulumi.Input[_builtins.str] tenancy_id: The custom model tenancy ID when modelId represents aliasName.
        """
        pulumi.set(__self__, "feature_type", feature_type)
        if generate_searchable_pdf is not None:
            pulumi.set(__self__, "generate_searchable_pdf", generate_searchable_pdf)
        if max_results is not None:
            pulumi.set(__self__, "max_results", max_results)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if selection_mark_detection is not None:
            pulumi.set(__self__, "selection_mark_detection", selection_mark_detection)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)

    @_builtins.property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of document analysis requested. The allowed values are:
        * `LANGUAGE_CLASSIFICATION`: Detect the language.
        * `TEXT_EXTRACTION`: Recognize text.
        * `TABLE_EXTRACTION`: Detect and extract data in tables.
        * `KEY_VALUE_EXTRACTION`: Extract form fields.
        * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        * `DOCUMENT_ELEMENTS_EXTRACTION`: Extract information from bar code
        """
        return pulumi.get(self, "feature_type")

    @feature_type.setter
    def feature_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "feature_type", value)

    @_builtins.property
    @pulumi.getter(name="generateSearchablePdf")
    def generate_searchable_pdf(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to generate a searchable PDF file.
        """
        return pulumi.get(self, "generate_searchable_pdf")

    @generate_searchable_pdf.setter
    def generate_searchable_pdf(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_searchable_pdf", value)

    @_builtins.property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of results to return.
        """
        return pulumi.get(self, "max_results")

    @max_results.setter
    def max_results(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_results", value)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier custom model OCID that should be used for inference.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_id", value)

    @_builtins.property
    @pulumi.getter(name="selectionMarkDetection")
    def selection_mark_detection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether checkbox detection feature is enabled or disabled.
        """
        return pulumi.get(self, "selection_mark_detection")

    @selection_mark_detection.setter
    def selection_mark_detection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "selection_mark_detection", value)

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenancy_id", value)


if not MYPY:
    class ProcessorJobProcessorConfigNormalizationFieldArgsDict(TypedDict):
        maps: NotRequired[pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigNormalizationFieldMapArgsDict']]]]
        """
        A wrapped map.
        """
elif False:
    ProcessorJobProcessorConfigNormalizationFieldArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobProcessorConfigNormalizationFieldArgs:
    def __init__(__self__, *,
                 maps: Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigNormalizationFieldMapArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigNormalizationFieldMapArgs']]] maps: A wrapped map.
        """
        if maps is not None:
            pulumi.set(__self__, "maps", maps)

    @_builtins.property
    @pulumi.getter
    def maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigNormalizationFieldMapArgs']]]]:
        """
        A wrapped map.
        """
        return pulumi.get(self, "maps")

    @maps.setter
    def maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigNormalizationFieldMapArgs']]]]):
        pulumi.set(self, "maps", value)


if not MYPY:
    class ProcessorJobProcessorConfigNormalizationFieldMapArgsDict(TypedDict):
        normalization_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        A string mapping to the normalization type.
        """
elif False:
    ProcessorJobProcessorConfigNormalizationFieldMapArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobProcessorConfigNormalizationFieldMapArgs:
    def __init__(__self__, *,
                 normalization_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] normalization_type: A string mapping to the normalization type.
        """
        if normalization_type is not None:
            pulumi.set(__self__, "normalization_type", normalization_type)

    @_builtins.property
    @pulumi.getter(name="normalizationType")
    def normalization_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string mapping to the normalization type.
        """
        return pulumi.get(self, "normalization_type")

    @normalization_type.setter
    def normalization_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "normalization_type", value)


if not MYPY:
    class ProjectLockArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Lock type.
        """
        compartment_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The compartment identifier.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        related_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        When the project was created, as an RFC3339 datetime string.
        """
elif False:
    ProjectLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectLockArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Lock type.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment identifier.
        :param pulumi.Input[_builtins.str] message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param pulumi.Input[_builtins.str] related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param pulumi.Input[_builtins.str] time_created: When the project was created, as an RFC3339 datetime string.
        """
        pulumi.set(__self__, "type", type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Lock type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the project was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class GetModelsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetModelsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetModelsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetProjectsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetProjectsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetProjectsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


